/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

public abstract class Assert {
    private Assert() {
    }

    public static void state(boolean state, String message) {
        if (!state) {
            throw new IllegalStateException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isFalse(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object value, String message) {
        Assert.isTrue(value != null, message);
    }

    public static void notEmpty(String value, String message) {
        Assert.notNull(value, message);
        Assert.isFalse(value.isEmpty(), message);
    }
}

