/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.interceptors;

import org.axonframework.commandhandling.CommandHandlerInterceptor;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.InterceptorChain;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.EventMessage;
import org.axonframework.serializer.SerializationAwareDomainEventMessage;
import org.axonframework.serializer.SerializationAwareEventMessage;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;

public class SerializationOptimizingInterceptor
implements CommandHandlerInterceptor {
    private final SerializationOptimizingListener listener = new SerializationOptimizingListener();

    @Override
    public Object handle(CommandMessage<?> commandMessage, UnitOfWork unitOfWork, InterceptorChain interceptorChain) throws Throwable {
        unitOfWork.registerListener(this.listener);
        return interceptorChain.proceed();
    }

    private static final class SerializationOptimizingListener
    extends UnitOfWorkListenerAdapter {
        private SerializationOptimizingListener() {
        }

        @Override
        public <T> EventMessage<T> onEventRegistered(UnitOfWork unitOfWork, EventMessage<T> event) {
            if (event instanceof DomainEventMessage) {
                return SerializationAwareDomainEventMessage.wrap((DomainEventMessage)event);
            }
            return SerializationAwareEventMessage.wrap(event);
        }
    }
}

