/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.interceptors;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.axonframework.commandhandling.CommandDispatchInterceptor;
import org.axonframework.commandhandling.CommandHandlerInterceptor;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.InterceptorChain;
import org.axonframework.commandhandling.interceptors.JSR303ViolationException;
import org.axonframework.unitofwork.UnitOfWork;

public class BeanValidationInterceptor
implements CommandHandlerInterceptor,
CommandDispatchInterceptor {
    private final ValidatorFactory validatorFactory;

    public BeanValidationInterceptor() {
        this(Validation.buildDefaultValidatorFactory());
    }

    public BeanValidationInterceptor(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public Object handle(CommandMessage<?> command, UnitOfWork unitOfWork, InterceptorChain interceptorChain) throws Throwable {
        return interceptorChain.proceed(this.handle(command));
    }

    @Override
    public CommandMessage<?> handle(CommandMessage<?> command) {
        Validator validator = this.validatorFactory.getValidator();
        Set<ConstraintViolation<Object>> violations = this.validateCommand(command.getPayload(), validator);
        if (violations != null && !violations.isEmpty()) {
            throw new JSR303ViolationException("One or more JSR303 constraints were violated.", violations);
        }
        return command;
    }

    protected Set<ConstraintViolation<Object>> validateCommand(Object command, Validator validator) {
        return validator.validate(command, new Class[0]);
    }
}

