/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonNonTransientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalRetryScheduler
implements RetryScheduler {
    private static final Logger logger = LoggerFactory.getLogger(IntervalRetryScheduler.class);
    private final int retryInterval;
    private final int maxRetryCount;
    private final ScheduledExecutorService retryExecutor;

    public IntervalRetryScheduler(ScheduledExecutorService executor, int interval, int maxRetryCount) {
        Assert.notNull(executor, "executor may not be null");
        this.retryExecutor = executor;
        this.retryInterval = interval;
        this.maxRetryCount = maxRetryCount;
    }

    @Override
    public boolean scheduleRetry(CommandMessage commandMessage, RuntimeException lastFailure, List<Class<? extends Throwable>[]> failures, Runnable dispatchTask) {
        int failureCount = failures.size();
        if (!this.isExplicitlyNonTransient(lastFailure) && failureCount <= this.maxRetryCount) {
            if (logger.isInfoEnabled()) {
                logger.info("Processing of Command [{}] resulted in an exception. Will retry {} more time(s)... Exception was {}, {}", new Object[]{commandMessage.getPayloadType().getSimpleName(), this.maxRetryCount - failureCount, lastFailure.getClass().getName(), lastFailure.getMessage()});
            }
            return this.scheduleRetry(dispatchTask, this.retryInterval);
        }
        if (failureCount >= this.maxRetryCount && logger.isInfoEnabled()) {
            logger.info("Processing of Command [{}] resulted in an exception {} times. Giving up permanently. ", new Object[]{commandMessage.getPayloadType().getSimpleName(), failureCount, lastFailure});
        } else if (logger.isInfoEnabled()) {
            logger.info("Processing of Command [{}] resulted in an exception and will not be retried. ", (Object)commandMessage.getPayloadType().getSimpleName(), (Object)lastFailure);
        }
        return false;
    }

    protected boolean isExplicitlyNonTransient(Throwable failure) {
        return failure instanceof AxonNonTransientException || failure.getCause() != null && this.isExplicitlyNonTransient(failure.getCause());
    }

    private boolean scheduleRetry(Runnable commandDispatch, int interval) {
        try {
            this.retryExecutor.schedule(commandDispatch, (long)interval, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (RejectedExecutionException e) {
            return false;
        }
    }
}

