/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandDispatchInterceptor;
import org.axonframework.commandhandling.callbacks.FutureCallback;
import org.axonframework.commandhandling.callbacks.NoOpCallback;
import org.axonframework.commandhandling.gateway.AbstractCommandGateway;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.RetryScheduler;

public class DefaultCommandGateway
extends AbstractCommandGateway
implements CommandGateway {
    public DefaultCommandGateway(CommandBus commandBus, CommandDispatchInterceptor ... commandDispatchInterceptors) {
        this(commandBus, (RetryScheduler)null, commandDispatchInterceptors);
    }

    public DefaultCommandGateway(CommandBus commandBus, RetryScheduler retryScheduler, CommandDispatchInterceptor ... commandDispatchInterceptors) {
        this(commandBus, retryScheduler, Arrays.asList(commandDispatchInterceptors));
    }

    public DefaultCommandGateway(CommandBus commandBus, RetryScheduler retryScheduler, List<CommandDispatchInterceptor> commandDispatchInterceptors) {
        super(commandBus, retryScheduler, commandDispatchInterceptors);
    }

    @Override
    public <R> void send(Object command, CommandCallback<R> callback) {
        super.send(command, callback);
    }

    @Override
    public <R> R sendAndWait(Object command) {
        FutureCallback futureCallback = new FutureCallback();
        this.send(command, futureCallback);
        return futureCallback.getResult();
    }

    @Override
    public <R> R sendAndWait(Object command, long timeout, TimeUnit unit) {
        FutureCallback futureCallback = new FutureCallback();
        this.send(command, futureCallback);
        return futureCallback.getResult(timeout, unit);
    }

    @Override
    public void send(Object command) {
        this.send(command, new NoOpCallback());
    }
}

