/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.disruptor;

import com.lmax.disruptor.EventFactory;
import java.util.List;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlerInterceptor;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.DefaultInterceptorChain;
import org.axonframework.commandhandling.InterceptorChain;
import org.axonframework.commandhandling.disruptor.BlacklistDetectingCallback;
import org.axonframework.commandhandling.disruptor.DisruptorUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;

public class CommandHandlingEntry {
    private final CommandHandler<Object> repeatingCommandHandler;
    private CommandMessage<?> command;
    private InterceptorChain invocationInterceptorChain;
    private InterceptorChain publisherInterceptorChain;
    private DisruptorUnitOfWork unitOfWork;
    private Throwable exceptionResult;
    private Object result;
    private int publisherSegmentId;
    private BlacklistDetectingCallback callback;
    private boolean isRecoverEntry;
    private Object aggregateIdentifier;
    private int invokerSegmentId;
    private int serializerSegmentId;
    private final boolean transactional;

    public CommandHandlingEntry(boolean transactional) {
        this.transactional = transactional;
        this.repeatingCommandHandler = new RepeatingCommandHandler();
    }

    public CommandMessage<?> getCommand() {
        return this.command;
    }

    public InterceptorChain getInvocationInterceptorChain() {
        return this.invocationInterceptorChain;
    }

    public InterceptorChain getPublisherInterceptorChain() {
        return this.publisherInterceptorChain;
    }

    public DisruptorUnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public void setExceptionResult(Throwable exceptionResult) {
        this.exceptionResult = exceptionResult;
    }

    public Throwable getExceptionResult() {
        return this.exceptionResult;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public BlacklistDetectingCallback getCallback() {
        return this.callback;
    }

    public boolean isRecoverEntry() {
        return this.isRecoverEntry;
    }

    public Object getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    public int getInvokerId() {
        return this.invokerSegmentId;
    }

    public int getSerializerSegmentId() {
        return this.serializerSegmentId;
    }

    public int getPublisherId() {
        return this.publisherSegmentId;
    }

    public void reset(CommandMessage<?> newCommand, CommandHandler newCommandHandler, int newInvokerSegmentId, int newPublisherSegmentId, int newSerializerSegmentId, BlacklistDetectingCallback newCallback, List<CommandHandlerInterceptor> invokerInterceptors, List<CommandHandlerInterceptor> publisherInterceptors) {
        this.command = newCommand;
        this.invokerSegmentId = newInvokerSegmentId;
        this.publisherSegmentId = newPublisherSegmentId;
        this.serializerSegmentId = newSerializerSegmentId;
        this.callback = newCallback;
        this.isRecoverEntry = false;
        this.aggregateIdentifier = null;
        this.result = null;
        this.exceptionResult = null;
        this.unitOfWork = new DisruptorUnitOfWork(this.transactional);
        this.invocationInterceptorChain = new DefaultInterceptorChain(newCommand, this.unitOfWork, newCommandHandler, invokerInterceptors);
        this.publisherInterceptorChain = new DefaultInterceptorChain(newCommand, this.unitOfWork, this.repeatingCommandHandler, publisherInterceptors);
    }

    public void resetAsRecoverEntry(Object newAggregateIdentifier) {
        this.isRecoverEntry = true;
        this.aggregateIdentifier = newAggregateIdentifier;
        this.command = null;
        this.callback = null;
        this.result = null;
        this.exceptionResult = null;
        this.invocationInterceptorChain = null;
        this.unitOfWork = null;
        this.invokerSegmentId = -1;
        this.serializerSegmentId = -1;
    }

    private class RepeatingCommandHandler
    implements CommandHandler<Object> {
        private RepeatingCommandHandler() {
        }

        @Override
        public Object handle(CommandMessage<Object> commandMessage, UnitOfWork uow) throws Throwable {
            if (CommandHandlingEntry.this.exceptionResult != null) {
                throw CommandHandlingEntry.this.exceptionResult;
            }
            return CommandHandlingEntry.this.result;
        }
    }

    public static class Factory
    implements EventFactory<CommandHandlingEntry> {
        private final boolean transactional;

        public Factory(boolean transactional) {
            this.transactional = transactional;
        }

        public CommandHandlingEntry newInstance() {
            return new CommandHandlingEntry(this.transactional);
        }
    }
}

