/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AbstractMessageHandler;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.common.annotation.UnsupportedHandlerException;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.Message;

public final class ConstructorCommandMessageHandler<T extends AggregateRoot>
extends AbstractMessageHandler {
    private final Constructor<T> constructor;

    public static <T extends AggregateRoot> ConstructorCommandMessageHandler<T> forConstructor(Constructor<T> constructor, ParameterResolverFactory parameterResolverFactory) {
        ParameterResolver[] resolvers = ConstructorCommandMessageHandler.findResolvers(parameterResolverFactory, constructor.getAnnotations(), constructor.getParameterTypes(), constructor.getParameterAnnotations(), true);
        Class<?> firstParameter = constructor.getParameterTypes()[0];
        Class payloadType = Message.class.isAssignableFrom(firstParameter) ? Object.class : firstParameter;
        ReflectionUtils.ensureAccessible(constructor);
        ConstructorCommandMessageHandler.validate(constructor, resolvers);
        return new ConstructorCommandMessageHandler<T>(constructor, resolvers, payloadType);
    }

    private static void validate(Constructor constructor, ParameterResolver[] parameterResolvers) {
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            if (parameterResolvers[i] != null) continue;
            throw new UnsupportedHandlerException(String.format("On method %s, parameter %s is invalid. It is not of any format supported by a providedParameterValueResolver.", constructor.toGenericString(), i + 1), constructor);
        }
    }

    private ConstructorCommandMessageHandler(Constructor<T> constructor, ParameterResolver[] parameterValueResolvers, Class payloadType) {
        super(payloadType, constructor.getDeclaringClass(), parameterValueResolvers);
        this.constructor = constructor;
    }

    public T invoke(Object target, Message message) throws InvocationTargetException, IllegalAccessException {
        Object[] parameterValues = new Object[this.getParameterValueResolvers().length];
        for (int i = 0; i < parameterValues.length; ++i) {
            parameterValues[i] = this.getParameterValueResolvers()[i].resolveParameterValue(message);
        }
        try {
            return (T)((AggregateRoot)this.constructor.newInstance(parameterValues));
        }
        catch (InstantiationException e) {
            throw new InvocationTargetException(e.getCause());
        }
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.constructor.getAnnotation(annotationType);
    }
}

