/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotation;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.annotation.AnnotationCommandHandlerAdapter;
import org.axonframework.common.annotation.AbstractAnnotationHandlerBeanPostProcessor;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.AggregateRoot;
import org.springframework.util.ReflectionUtils;

public class AnnotationCommandHandlerBeanPostProcessor
extends AbstractAnnotationHandlerBeanPostProcessor<CommandHandler, AnnotationCommandHandlerAdapter> {
    private CommandBus commandBus;

    @Override
    protected Class<CommandHandler> getAdapterInterface() {
        return CommandHandler.class;
    }

    @Override
    protected boolean isPostProcessingCandidate(Class<?> targetClass) {
        return this.isNotCommandHandlerSubclass(targetClass) && this.hasCommandHandlerMethod(targetClass);
    }

    @Override
    protected AnnotationCommandHandlerAdapter initializeAdapterFor(Object bean, ParameterResolverFactory parameterResolverFactory) {
        return new AnnotationCommandHandlerAdapter(bean, parameterResolverFactory);
    }

    private void ensureCommandBusInitialized() {
        if (this.commandBus == null) {
            Map beans = this.getApplicationContext().getBeansOfType(CommandBus.class);
            if (beans.size() != 1) {
                throw new IllegalStateException("If no specific CommandBus is provided, the application context must contain exactly one bean of type CommandBus. The current application context has: " + beans.size());
            }
            this.commandBus = (CommandBus)beans.entrySet().iterator().next().getValue();
        }
    }

    private boolean isNotCommandHandlerSubclass(Class<?> beanClass) {
        return !CommandHandler.class.isAssignableFrom(beanClass) && !AggregateRoot.class.isAssignableFrom(beanClass);
    }

    private boolean hasCommandHandlerMethod(Class<?> beanClass) {
        AtomicBoolean result = new AtomicBoolean(false);
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new HasEventHandlerAnnotationMethodCallback(result));
        return result.get();
    }

    @Override
    protected void subscribe(CommandHandler bean, AnnotationCommandHandlerAdapter adapter) {
        this.ensureCommandBusInitialized();
        for (String cmd : adapter.supportedCommands()) {
            this.commandBus.subscribe(cmd, bean);
        }
    }

    @Override
    protected void unsubscribe(CommandHandler bean, AnnotationCommandHandlerAdapter adapter) {
        if (this.commandBus != null) {
            for (String cmd : adapter.supportedCommands()) {
                this.commandBus.unsubscribe(cmd, bean);
            }
        }
    }

    public void setCommandBus(CommandBus commandBus) {
        this.commandBus = commandBus;
    }

    private static final class HasEventHandlerAnnotationMethodCallback
    implements ReflectionUtils.MethodCallback {
        private final AtomicBoolean result;

        private HasEventHandlerAnnotationMethodCallback(AtomicBoolean result) {
            this.result = result;
        }

        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            if (method.isAnnotationPresent(org.axonframework.commandhandling.annotation.CommandHandler.class)) {
                this.result.set(true);
            }
        }
    }
}

