/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotation;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.annotation.CommandMessageHandlerUtils;
import org.axonframework.common.Assert;
import org.axonframework.common.Subscribable;
import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.common.annotation.MethodMessageHandler;
import org.axonframework.common.annotation.MethodMessageHandlerInspector;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.unitofwork.UnitOfWork;

public class AnnotationCommandHandlerAdapter
implements CommandHandler<Object>,
Subscribable {
    private final CommandBus commandBus;
    private final Map<String, MethodMessageHandler> handlers = new HashMap<String, MethodMessageHandler>();
    private final Object target;
    private final ParameterResolverFactory parameterResolverFactory;

    public static AnnotationCommandHandlerAdapter subscribe(Object annotatedCommandHandler, CommandBus commandBus) {
        AnnotationCommandHandlerAdapter adapter = new AnnotationCommandHandlerAdapter(annotatedCommandHandler);
        for (String cmd : adapter.supportedCommands()) {
            commandBus.subscribe(cmd, adapter);
        }
        return adapter;
    }

    public static void subscribe(AnnotationCommandHandlerAdapter annotationCommandHandler, CommandBus commandBus) {
        for (String supportedCommand : annotationCommandHandler.supportedCommands()) {
            commandBus.subscribe(supportedCommand, annotationCommandHandler);
        }
    }

    @Deprecated
    public AnnotationCommandHandlerAdapter(Object target, CommandBus commandBus) {
        Assert.notNull(target, "target may not be null");
        this.parameterResolverFactory = ClasspathParameterResolverFactory.forClass(target.getClass());
        MethodMessageHandlerInspector inspector = MethodMessageHandlerInspector.getInstance(target.getClass(), org.axonframework.commandhandling.annotation.CommandHandler.class, this.parameterResolverFactory, true);
        for (MethodMessageHandler handler : inspector.getHandlers()) {
            String commandName = CommandMessageHandlerUtils.resolveAcceptedCommandName(handler);
            this.handlers.put(commandName, handler);
        }
        this.target = target;
        this.commandBus = commandBus;
    }

    public AnnotationCommandHandlerAdapter(Object annotatedCommandHandler) {
        this(annotatedCommandHandler, ClasspathParameterResolverFactory.forClass(annotatedCommandHandler.getClass()));
    }

    public AnnotationCommandHandlerAdapter(Object annotatedCommandHandler, ParameterResolverFactory parameterResolverFactory) {
        Assert.notNull(annotatedCommandHandler, "annotatedCommandHandler may not be null");
        MethodMessageHandlerInspector inspector = MethodMessageHandlerInspector.getInstance(annotatedCommandHandler.getClass(), org.axonframework.commandhandling.annotation.CommandHandler.class, parameterResolverFactory, true);
        for (MethodMessageHandler handler : inspector.getHandlers()) {
            String commandName = CommandMessageHandlerUtils.resolveAcceptedCommandName(handler);
            this.handlers.put(commandName, handler);
        }
        this.parameterResolverFactory = parameterResolverFactory;
        this.target = annotatedCommandHandler;
        this.commandBus = null;
    }

    @Override
    public Object handle(CommandMessage<Object> command, UnitOfWork unitOfWork) throws Throwable {
        try {
            MethodMessageHandler handler = this.handlers.get(command.getCommandName());
            if (handler == null) {
                throw new NoHandlerForCommandException("No handler found for command " + command.getCommandName());
            }
            if (unitOfWork != null) {
                unitOfWork.attachResource(ParameterResolverFactory.class.getName(), this.parameterResolverFactory);
            }
            return handler.invoke(this.target, command);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Override
    @PostConstruct
    @Deprecated
    public void subscribe() {
        if (this.commandBus != null) {
            for (String acceptedCommand : this.handlers.keySet()) {
                this.commandBus.subscribe(acceptedCommand, this);
            }
        }
    }

    @Override
    @PreDestroy
    @Deprecated
    public void unsubscribe() {
        if (this.commandBus != null) {
            for (String acceptedCommand : this.handlers.keySet()) {
                this.commandBus.unsubscribe(acceptedCommand, this);
            }
        }
    }

    public Set<String> supportedCommands() {
        return this.handlers.keySet();
    }
}

