/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotation;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.VersionedAggregateIdentifier;
import org.axonframework.commandhandling.annotation.AggregateCommandHandlerInspector;
import org.axonframework.commandhandling.annotation.AnnotationCommandTargetResolver;
import org.axonframework.commandhandling.annotation.CommandMessageHandlerUtils;
import org.axonframework.commandhandling.annotation.ConstructorCommandMessageHandler;
import org.axonframework.common.Assert;
import org.axonframework.common.Subscribable;
import org.axonframework.common.annotation.AbstractMessageHandler;
import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.repository.Repository;
import org.axonframework.unitofwork.UnitOfWork;

public class AggregateAnnotationCommandHandler<T extends AggregateRoot>
implements Subscribable,
CommandHandler<Object> {
    private final CommandBus commandBus;
    private final Repository<T> repository;
    private final CommandTargetResolver commandTargetResolver;
    private final Map<String, CommandHandler<Object>> handlers;
    private final ParameterResolverFactory parameterResolverFactory;

    public AggregateAnnotationCommandHandler(Class<T> aggregateType, Repository<T> repository) {
        this(aggregateType, repository, new AnnotationCommandTargetResolver());
    }

    public AggregateAnnotationCommandHandler(Class<T> aggregateType, Repository<T> repository, CommandTargetResolver commandTargetResolver) {
        this(aggregateType, repository, commandTargetResolver, ClasspathParameterResolverFactory.forClass(aggregateType));
    }

    public AggregateAnnotationCommandHandler(Class<T> aggregateType, Repository<T> repository, CommandTargetResolver commandTargetResolver, ParameterResolverFactory parameterResolverFactory) {
        this.parameterResolverFactory = parameterResolverFactory;
        Assert.notNull(aggregateType, "aggregateType may not be null");
        Assert.notNull(repository, "repository may not be null");
        Assert.notNull(commandTargetResolver, "commandTargetResolver may not be null");
        this.repository = repository;
        this.commandBus = null;
        this.commandTargetResolver = commandTargetResolver;
        this.handlers = this.initializeHandlers(new AggregateCommandHandlerInspector<T>(aggregateType, parameterResolverFactory));
    }

    @Deprecated
    public AggregateAnnotationCommandHandler(Class<T> aggregateType, Repository<T> repository, CommandBus commandBus) {
        this(aggregateType, repository, commandBus, new AnnotationCommandTargetResolver());
    }

    @Deprecated
    public AggregateAnnotationCommandHandler(Class<T> aggregateType, Repository<T> repository, CommandBus commandBus, CommandTargetResolver commandTargetResolver) {
        Assert.notNull(aggregateType, "aggregateType may not be null");
        Assert.notNull(repository, "repository may not be null");
        Assert.notNull(commandTargetResolver, "commandTargetResolver may not be null");
        this.repository = repository;
        this.commandBus = commandBus;
        this.commandTargetResolver = commandTargetResolver;
        this.parameterResolverFactory = ClasspathParameterResolverFactory.forClass(aggregateType);
        this.handlers = this.initializeHandlers(new AggregateCommandHandlerInspector<T>(aggregateType, this.parameterResolverFactory));
    }

    public static <T extends AggregateRoot> AggregateAnnotationCommandHandler subscribe(Class<T> aggregateType, Repository<T> repository, CommandBus commandBus) {
        AggregateAnnotationCommandHandler<T> adapter = new AggregateAnnotationCommandHandler<T>(aggregateType, repository);
        for (String supportedCommand : adapter.supportedCommands()) {
            commandBus.subscribe(supportedCommand, adapter);
        }
        return adapter;
    }

    public static <T extends AggregateRoot> AggregateAnnotationCommandHandler subscribe(Class<T> aggregateType, Repository<T> repository, CommandBus commandBus, CommandTargetResolver commandTargetResolver) {
        AggregateAnnotationCommandHandler<T> adapter = new AggregateAnnotationCommandHandler<T>(aggregateType, repository, commandTargetResolver);
        for (String supportedCommand : adapter.supportedCommands()) {
            commandBus.subscribe(supportedCommand, adapter);
        }
        return adapter;
    }

    public static void subscribe(AggregateAnnotationCommandHandler<?> aggregateAnnotationCommandHandler, CommandBus commandBus) {
        for (String supportedCommand : aggregateAnnotationCommandHandler.supportedCommands()) {
            commandBus.subscribe(supportedCommand, aggregateAnnotationCommandHandler);
        }
    }

    private Map<String, CommandHandler<Object>> initializeHandlers(AggregateCommandHandlerInspector<T> inspector) {
        HashMap<String, CommandHandler<Object>> handlersFound = new HashMap<String, CommandHandler<Object>>();
        for (AbstractMessageHandler abstractMessageHandler : inspector.getHandlers()) {
            handlersFound.put(CommandMessageHandlerUtils.resolveAcceptedCommandName(abstractMessageHandler), new AggregateCommandHandler(abstractMessageHandler));
        }
        for (ConstructorCommandMessageHandler constructorCommandMessageHandler : inspector.getConstructorHandlers()) {
            handlersFound.put(CommandMessageHandlerUtils.resolveAcceptedCommandName(constructorCommandMessageHandler), new AggregateConstructorCommandHandler(constructorCommandMessageHandler));
        }
        return handlersFound;
    }

    @Override
    @PreDestroy
    @Deprecated
    public synchronized void unsubscribe() {
        if (this.commandBus != null) {
            for (String commandType : this.handlers.keySet()) {
                this.commandBus.unsubscribe(commandType, this);
            }
        }
    }

    @Override
    @PostConstruct
    @Deprecated
    public synchronized void subscribe() {
        if (this.commandBus != null) {
            for (String commandType : this.handlers.keySet()) {
                this.commandBus.subscribe(commandType, this);
            }
        }
    }

    public Set<String> supportedCommands() {
        return this.handlers.keySet();
    }

    @Override
    public Object handle(CommandMessage<Object> commandMessage, UnitOfWork unitOfWork) throws Throwable {
        unitOfWork.attachResource(ParameterResolverFactory.class.getName(), this.parameterResolverFactory);
        return this.handlers.get(commandMessage.getCommandName()).handle(commandMessage, unitOfWork);
    }

    private T loadAggregate(CommandMessage<?> command) {
        VersionedAggregateIdentifier iv = this.commandTargetResolver.resolveTarget(command);
        return (T)((AggregateRoot)this.repository.load(iv.getIdentifier(), iv.getVersion()));
    }

    protected Object resolveReturnValue(CommandMessage<?> command, T createdAggregate) {
        return createdAggregate.getIdentifier();
    }

    private class AggregateCommandHandler
    implements CommandHandler<Object> {
        private final AbstractMessageHandler commandHandler;

        public AggregateCommandHandler(AbstractMessageHandler commandHandler) {
            this.commandHandler = commandHandler;
        }

        @Override
        public Object handle(CommandMessage<Object> command, UnitOfWork unitOfWork) throws Throwable {
            AggregateRoot aggregate = AggregateAnnotationCommandHandler.this.loadAggregate(command);
            try {
                return this.commandHandler.invoke(aggregate, command);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    private class AggregateConstructorCommandHandler
    implements CommandHandler<Object> {
        private final ConstructorCommandMessageHandler<T> handler;

        public AggregateConstructorCommandHandler(ConstructorCommandMessageHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public Object handle(CommandMessage<Object> command, UnitOfWork unitOfWork) throws Throwable {
            try {
                Object createdAggregate = this.handler.invoke(null, command);
                AggregateAnnotationCommandHandler.this.repository.add(createdAggregate);
                return AggregateAnnotationCommandHandler.this.resolveReturnValue(command, createdAggregate);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

