/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.commandhandling.SimpleCommandBusStatisticsMXBean;

public class SimpleCommandBusStatistics
implements SimpleCommandBusStatisticsMXBean {
    private final AtomicLong handlerCounter = new AtomicLong(0L);
    private final AtomicLong receivedCommandCounter = new AtomicLong(0L);
    private final List<String> handlerTypes = new CopyOnWriteArrayList<String>();

    @Override
    public long getCommandHandlerCount() {
        return this.handlerCounter.get();
    }

    @Override
    public long getReceivedCommandCount() {
        return this.receivedCommandCounter.get();
    }

    @Override
    public List<String> getHandlerTypes() {
        return Collections.unmodifiableList(this.handlerTypes);
    }

    @Override
    public void resetReceivedCommandsCounter() {
        this.receivedCommandCounter.set(0L);
    }

    void reportHandlerRegistered(String name) {
        this.handlerTypes.add(name);
        this.handlerCounter.incrementAndGet();
    }

    void recordUnregisteredHandler(String name) {
        this.handlerTypes.remove(name);
        this.handlerCounter.decrementAndGet();
    }

    void recordReceivedCommand() {
        this.receivedCommandCounter.incrementAndGet();
    }
}

