/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.cache.Cache;

public abstract class AbstractCacheAdapter<L>
implements Cache {
    private final ConcurrentMap<Cache.EntryListener, L> registeredAdapters = new ConcurrentHashMap<Cache.EntryListener, L>();

    protected abstract L createListenerAdapter(Cache.EntryListener var1);

    @Override
    public void registerCacheEntryListener(Cache.EntryListener entryListener) {
        L adapter = this.createListenerAdapter(entryListener);
        if (this.registeredAdapters.putIfAbsent(entryListener, adapter) == null) {
            this.doRegisterListener(adapter);
        }
    }

    @Override
    public void unregisterCacheEntryListener(Cache.EntryListener entryListener) {
        Object adapter = this.registeredAdapters.remove(entryListener);
        if (adapter != null) {
            this.doUnregisterListener(adapter);
        }
    }

    protected abstract void doUnregisterListener(L var1);

    protected abstract void doRegisterListener(L var1);
}

