/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.auditing;

import java.util.Collections;
import java.util.Map;
import org.axonframework.auditing.AuditDataProvider;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.Assert;

public class CorrelationAuditDataProvider
implements AuditDataProvider {
    public static final String DEFAULT_CORRELATION_KEY = "command-identifier";
    private final String correlationIdKey;

    public CorrelationAuditDataProvider() {
        this(DEFAULT_CORRELATION_KEY);
    }

    public CorrelationAuditDataProvider(String correlationIdKey) {
        Assert.notNull(correlationIdKey, "correlationIdKey may not be null");
        this.correlationIdKey = correlationIdKey;
    }

    @Override
    public Map<String, Object> provideAuditDataFor(CommandMessage<?> command) {
        return Collections.singletonMap(this.correlationIdKey, command.getIdentifier());
    }
}

