/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.auditing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.axonframework.auditing.AuditDataProvider;
import org.axonframework.auditing.AuditLogger;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.Assert;
import org.axonframework.domain.EventMessage;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;

public class AuditingUnitOfWorkListener
extends UnitOfWorkListenerAdapter {
    private final AuditDataProvider auditDataProvider;
    private final AuditLogger auditLogger;
    private final CommandMessage<?> command;
    private final List<EventMessage> recordedEvents = new ArrayList<EventMessage>();
    private volatile Object returnValue;

    public AuditingUnitOfWorkListener(CommandMessage<?> command, AuditDataProvider auditDataProvider, AuditLogger auditLogger) {
        Assert.notNull(command, "command may not be null");
        Assert.notNull(auditDataProvider, "auditDataProvider may not be null");
        Assert.notNull(auditLogger, "auditLogger may not be null");
        this.auditDataProvider = auditDataProvider;
        this.auditLogger = auditLogger;
        this.command = command;
    }

    @Override
    public void afterCommit(UnitOfWork unitOfWork) {
        this.auditLogger.logSuccessful(this.command, this.returnValue, this.recordedEvents);
    }

    @Override
    public void onRollback(UnitOfWork unitOfWork, Throwable failureCause) {
        this.auditLogger.logFailed(this.command, failureCause, this.recordedEvents);
    }

    @Override
    public <T> EventMessage<T> onEventRegistered(UnitOfWork unitOfWork, EventMessage<T> event) {
        Map<String, Object> auditData = this.auditDataProvider.provideAuditDataFor(this.command);
        if (!auditData.isEmpty()) {
            event = event.andMetaData(auditData);
        }
        this.recordedEvents.add(event);
        return event;
    }

    void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }
}

