/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.registry;

import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.uritemplate.UriTemplateMatcher;
import org.apache.wink.server.internal.registry.ResourceRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceInstance {
    private ResourceRecord record;
    private UriTemplateMatcher matcher;
    private Object instance;

    public ResourceInstance(ResourceRecord record, UriTemplateMatcher matcher) {
        this(null, record, matcher);
    }

    public ResourceInstance(Object instance, ResourceRecord record, UriTemplateMatcher matcher) {
        this.instance = instance;
        this.record = record;
        this.matcher = matcher;
    }

    public ResourceRecord getRecord() {
        return this.record;
    }

    public UriTemplateMatcher getMatcher() {
        return this.matcher;
    }

    public Object getInstance(RuntimeContext context) {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = this.record.getObjectFactory().getInstance(context);
        return this.instance;
    }

    public void releaseInstance(RuntimeContext context) {
        if (this.instance != null) {
            ObjectFactory<?> of = this.record.getObjectFactory();
            of.releaseInstance(this.instance, context);
        }
    }

    public boolean isExactMatch() {
        return this.matcher.isExactMatch();
    }

    public String toString() {
        return String.format("ResourceRecord: %s; UriTemplateMatcher: %s", this.record, this.matcher);
    }

    public Class<?> getResourceClass() {
        return this.record.getMetadata().getResourceClass();
    }
}

