/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.identity;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.identity.SecurityIdentityImplementationPolicyInterceptor;
import org.apache.tuscany.sca.policy.identity.SecurityIdentityPolicy;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityIdentityImplementationPolicyProvider
implements PolicyProvider {
    private RuntimeComponent component;
    private Implementation implementation;

    public SecurityIdentityImplementationPolicyProvider(RuntimeComponent component) {
        this.component = component;
        this.implementation = component.getImplementation();
    }

    private List<SecurityIdentityPolicy> findPolicies(Operation op) {
        ArrayList<SecurityIdentityPolicy> polices = new ArrayList<SecurityIdentityPolicy>();
        List policySets = this.component.getPolicySets();
        for (PolicySet ps : policySets) {
            for (Object p : ps.getPolicies()) {
                if (!SecurityIdentityPolicy.class.isInstance(p)) continue;
                polices.add((SecurityIdentityPolicy)p);
            }
        }
        return polices;
    }

    public PhasedInterceptor createInterceptor(Operation operation) {
        List<SecurityIdentityPolicy> policies = this.findPolicies(operation);
        if (policies == null || policies.isEmpty()) {
            return null;
        }
        return new SecurityIdentityImplementationPolicyInterceptor(this.findPolicies(operation));
    }

    public void start() {
    }

    public void stop() {
    }
}

