/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.authentication.basic;

import java.util.List;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationServicePolicyInterceptor;
import org.apache.tuscany.sca.provider.PolicyProvider;

public class BasicAuthenticationServicePolicyProvider
implements PolicyProvider {
    private Endpoint endpoint;

    public BasicAuthenticationServicePolicyProvider(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    private PolicySet findPolicySet() {
        List policySets = this.endpoint.getPolicySets();
        for (PolicySet ps : policySets) {
            for (Object p : ps.getPolicies()) {
                if (!BasicAuthenticationPolicy.class.isInstance(p)) continue;
                return ps;
            }
        }
        return null;
    }

    private String getContext() {
        return this.endpoint.getURI();
    }

    public PhasedInterceptor createInterceptor(Operation operation) {
        PolicySet ps = this.findPolicySet();
        return ps == null ? null : new BasicAuthenticationServicePolicyInterceptor(this.getContext(), operation, ps);
    }

    public void start() {
    }

    public void stop() {
    }
}

