/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.authentication.basic;

import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPrincipal;
import org.apache.tuscany.sca.policy.security.SecurityUtil;

public class BasicAuthenticationServicePolicyInterceptor
implements PhasedInterceptor {
    private static final String SCA10_TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.1";
    public static final QName policySetQName = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "wsBasicAuthentication");
    private Invoker next;
    private Operation operation;
    private PolicySet policySet = null;
    private String context;
    private BasicAuthenticationPolicy policy;

    public BasicAuthenticationServicePolicyInterceptor(String context, Operation operation, PolicySet policySet) {
        this.operation = operation;
        this.policySet = policySet;
        this.context = context;
        this.init();
    }

    private void init() {
        if (this.policySet != null) {
            for (Object policyObject : this.policySet.getPolicies()) {
                if (!(policyObject instanceof BasicAuthenticationPolicy)) continue;
                this.policy = (BasicAuthenticationPolicy)policyObject;
                break;
            }
        }
    }

    public Message invoke(Message msg) {
        Subject subject = SecurityUtil.getSubject(msg);
        BasicAuthenticationPrincipal principal = SecurityUtil.getPrincipal(subject, BasicAuthenticationPrincipal.class);
        if (principal != null) {
            System.out.println("Username: " + principal.getName() + " Password: " + principal.getPassword());
        }
        return this.getNext().invoke(msg);
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public String getPhase() {
        return "service.policy";
    }
}

