/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.authentication.basic;

import java.util.List;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationReferencePolicyInterceptor;
import org.apache.tuscany.sca.provider.PolicyProvider;

public class BasicAuthenticationReferencePolicyProvider
implements PolicyProvider {
    private EndpointReference endpointReference;

    public BasicAuthenticationReferencePolicyProvider(EndpointReference endpointReference) {
        this.endpointReference = endpointReference;
    }

    private PolicySet findPolicySet() {
        List policySets = this.endpointReference.getPolicySets();
        for (PolicySet ps : policySets) {
            for (Object p : ps.getPolicies()) {
                if (!BasicAuthenticationPolicy.class.isInstance(p)) continue;
                return ps;
            }
        }
        return null;
    }

    private String getContext() {
        return this.endpointReference.getURI();
    }

    public PhasedInterceptor createInterceptor(Operation operation) {
        PolicySet ps = this.findPolicySet();
        return ps == null ? null : new BasicAuthenticationReferencePolicyInterceptor(this.getContext(), operation, ps);
    }

    public void start() {
    }

    public void stop() {
    }
}

