/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.policy.util.PolicyHandler;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyHandlerDefinitionsLoader {
    public static Map<ClassLoader, List<PolicyHandlerTuple>> loadPolicyHandlerClassnames() {
        Set sds;
        try {
            sds = ServiceDiscovery.getInstance().getServiceDeclarations(PolicyHandler.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        Hashtable<ClassLoader, List<PolicyHandlerTuple>> handlerTuples = new Hashtable<ClassLoader, List<PolicyHandlerTuple>>();
        for (ServiceDeclaration sd : sds) {
            ClassLoader cl = sd.getClassLoader();
            ArrayList<PolicyHandlerTuple> handlerTupleList = (ArrayList<PolicyHandlerTuple>)handlerTuples.get(cl);
            if (handlerTupleList == null) {
                handlerTupleList = new ArrayList<PolicyHandlerTuple>();
                handlerTuples.put(cl, handlerTupleList);
            }
            Map attributes = sd.getAttributes();
            String intentName = (String)attributes.get("intent");
            QName intentQName = PolicyHandlerDefinitionsLoader.getQName(intentName);
            String policyModelClassName = (String)attributes.get("model");
            String appliesTo = (String)attributes.get("appliesTo");
            if (appliesTo != null && !appliesTo.startsWith("/")) {
                appliesTo = "//" + appliesTo;
            }
            handlerTupleList.add(new PolicyHandlerTuple(sd.getClassName(), intentQName, policyModelClassName, appliesTo));
        }
        return handlerTuples;
    }

    private static QName getQName(String qname) {
        if (qname == null) {
            return null;
        }
        if ((qname = qname.trim()).startsWith("{")) {
            int h = qname.indexOf(125);
            if (h != -1) {
                return new QName(qname.substring(1, h), qname.substring(h + 1));
            }
        } else {
            int h = qname.indexOf(35);
            if (h != -1) {
                return new QName(qname.substring(0, h), qname.substring(h + 1));
            }
        }
        throw new IllegalArgumentException("Invalid qname: " + qname);
    }
}

