/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.policy.Intent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentImpl
implements Intent {
    private static final String QUALIFIED_SEPARATOR = ".";
    private static final String DOMAIN_SEPARATOR = ".";
    private QName name;
    private List<QName> constrains = new ArrayList<QName>();
    private String description;
    private List<Intent> qualifiedIntents = new ArrayList<Intent>();
    private List<Intent> excludedIntents = new ArrayList<Intent>();
    private boolean unresolved = true;
    private String domain;
    private String[] qualifiedNames;

    protected IntentImpl() {
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public void setName(QName name) {
        this.name = name;
        String iname = name.getLocalPart();
        int domainIdx = iname.indexOf(".");
        if (domainIdx > -1) {
            this.domain = iname.substring(0, domainIdx);
            String qualifNamesStr = iname.substring(domainIdx + 1);
            String pattern = "\\.";
            this.qualifiedNames = qualifNamesStr.split(pattern);
        } else {
            this.domain = iname;
        }
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String[] getQualifiedNames() {
        String[] results = new String[this.qualifiedNames.length];
        System.arraycopy(this.qualifiedNames, 0, results, 0, this.qualifiedNames.length);
        return results;
    }

    @Override
    public List<QName> getConstrains() {
        return this.constrains;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<Intent> getQualifiedIntents() {
        return this.qualifiedIntents;
    }

    @Override
    public List<Intent> getExcludedIntents() {
        return this.excludedIntents;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        QName intentName = this.getName();
        result = 31 * result + (intentName == null ? 0 : intentName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentImpl)) {
            return false;
        }
        IntentImpl other = (IntentImpl)obj;
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    public String toString() {
        return String.valueOf(this.getName());
    }
}

