/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.equinox.launcher;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tuscany.sca.node.equinox.launcher.Contribution;
import org.apache.tuscany.sca.node.equinox.launcher.DomainManagerLauncher;
import org.apache.tuscany.sca.node.equinox.launcher.LauncherException;
import org.apache.tuscany.sca.node.equinox.launcher.NodeDaemonLauncher;
import org.apache.tuscany.sca.node.equinox.launcher.NodeLauncher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

final class NodeLauncherUtil {
    private static final String NODE_API_BUNDLE = "org.apache.tuscany.sca.node.api";
    private static final String BASE_BUNDLE = "org.apache.tuscany.sca.base";
    private static final Logger logger = Logger.getLogger(NodeLauncherUtil.class.getName());
    static final String META_INF_SERVICES = "META-INF.services;partial=true;mandatory:=partial";
    static final String LAUNCHER_EQUINOX_LIBRARIES = "org.apache.tuscany.sca.node.launcher.equinox.libraries";
    static final String GATEWAY_BUNDLE = "org.apache.tuscany.sca.gateway";
    private static final String NODE_FACTORY = "org.apache.tuscany.sca.node.NodeFactory";
    private static final String DOMAIN_MANAGER_LAUNCHER_BOOTSTRAP = "org.apache.tuscany.sca.domain.manager.launcher.DomainManagerLauncherBootstrap";
    private static final String NODE_IMPLEMENTATION_DAEMON_BOOTSTRAP = "org.apache.tuscany.sca.implementation.node.launcher.NodeImplementationDaemonBootstrap";
    private static final String TUSCANY_HOME = "TUSCANY_HOME";
    private static final String TUSCANY_PATH = "TUSCANY_PATH";
    private static Pattern pattern = Pattern.compile("-(\\d)+((\\.|-|_)(\\d)+){0,2}");

    NodeLauncherUtil() {
    }

    static Object node(String configurationURI, String compositeURI, String compositeContent, Contribution[] contributions, BundleContext bundleContext) throws LauncherException {
        try {
            Bundle bundle = null;
            for (Bundle b : bundleContext.getBundles()) {
                if (NODE_API_BUNDLE.equals(b.getSymbolicName())) {
                    bundle = b;
                    break;
                }
                if (!b.getSymbolicName().contains(BASE_BUNDLE)) continue;
                bundle = b;
                break;
            }
            if (bundle == null) {
                throw new IllegalStateException("Bundle org.apache.tuscany.sca.node.api is not installed");
            }
            Class bootstrapClass = bundle.loadClass(NODE_FACTORY);
            Object node = NodeLauncherUtil.createNode(bootstrapClass, configurationURI, compositeURI, compositeContent, contributions);
            try {
                Class<?> type = Class.forName(NODE_FACTORY);
                type = type.getDeclaredClasses()[0];
                return type.getMethod("createProxy", Class.class, Object.class).invoke(null, type, node);
            }
            catch (ClassNotFoundException e) {
                return node;
            }
        }
        catch (Exception e) {
            NodeLauncher.logger.log(Level.SEVERE, "SCA Node could not be created", e);
            throw new LauncherException(e);
        }
    }

    private static Object createNode(Class<?> bootstrapClass, String configurationURI, String compositeURI, String compositeContent, Contribution[] contributions) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, MalformedURLException {
        Object node;
        Method newInstance = bootstrapClass.getMethod("newInstance", new Class[0]);
        Object nodeFactory = newInstance.invoke(null, new Object[0]);
        if (configurationURI != null) {
            Method create = bootstrapClass.getMethod("createNode", URL.class);
            node = create.invoke(nodeFactory, new URL(configurationURI));
        } else if (compositeContent != null) {
            Method create = bootstrapClass.getMethod("createNode", Reader.class, String[].class, String[].class);
            String[] uris = new String[contributions.length];
            String[] locations = new String[contributions.length];
            for (int i = 0; i < contributions.length; ++i) {
                uris[i] = contributions[i].getURI();
                locations[i] = contributions[i].getLocation();
            }
            node = create.invoke(nodeFactory, compositeContent, uris, locations);
        } else {
            Method create = bootstrapClass.getMethod("createNode", String.class, String[].class, String[].class);
            String[] uris = new String[contributions.length];
            String[] locations = new String[contributions.length];
            for (int i = 0; i < contributions.length; ++i) {
                uris[i] = contributions[i].getURI();
                locations[i] = contributions[i].getLocation();
            }
            node = create.invoke(nodeFactory, compositeURI, uris, locations);
        }
        return node;
    }

    static Object nodeDaemon() throws LauncherException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Object nodeDaemon;
            String className = NODE_IMPLEMENTATION_DAEMON_BOOTSTRAP;
            Class<?> bootstrapClass = Class.forName(className, false, tccl);
            Object bootstrap = bootstrapClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Object object = nodeDaemon = bootstrapClass.getMethod("getNode", new Class[0]).invoke(bootstrap, new Object[0]);
            return object;
        }
        catch (Exception e) {
            NodeDaemonLauncher.logger.log(Level.SEVERE, "SCA Node Daemon could not be created", e);
            throw new LauncherException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    static Object domainManager(String rootDirectory) throws LauncherException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Object domainManager;
            String className = DOMAIN_MANAGER_LAUNCHER_BOOTSTRAP;
            Class<?> bootstrapClass = Class.forName(className, false, tccl);
            Constructor<?> constructor = bootstrapClass.getConstructor(String.class);
            Object bootstrap = constructor.newInstance(rootDirectory);
            Object object = domainManager = bootstrapClass.getMethod("getNode", new Class[0]).invoke(bootstrap, new Object[0]);
            return object;
        }
        catch (Exception e) {
            DomainManagerLauncher.logger.log(Level.SEVERE, "SCA Domain Manager could not be created", e);
            throw new LauncherException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    static String jarVersion(URL jarFile) {
        String name = jarFile.getFile();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        if ((index = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, index);
        }
        Matcher matcher = pattern.matcher(name);
        String version = "0.0.0";
        if (matcher.find()) {
            version = matcher.group();
            version = version.substring(1);
            version = version.replace('-', '.');
            version = version.replace('_', '.');
        }
        return version;
    }

    static String artifactId(URL jarFile) {
        Matcher matcher;
        String name = jarFile.getFile();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        if ((index = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, index);
        }
        if ((matcher = pattern.matcher(name)).find()) {
            return name.substring(0, matcher.start());
        }
        return name;
    }

    private static void addPackages(URL jarFile, Set<String> packages, String version) throws IOException {
        version = version == null ? ";version=" + NodeLauncherUtil.jarVersion(jarFile) : ";version=" + version;
        File file = NodeLauncherUtil.file(jarFile);
        if (file.isDirectory()) {
            List<String> classFiles = NodeLauncherUtil.listClassFiles(file);
            for (String cls : classFiles) {
                int index = cls.lastIndexOf(47);
                if (index == -1) continue;
                String pkg = cls.substring(0, index);
                if ("META-INF.services".equals(pkg = pkg.replace('/', '.') + version)) {
                    packages.add(META_INF_SERVICES);
                    continue;
                }
                packages.add(pkg);
            }
        } else if (file.isFile()) {
            ZipEntry entry;
            ZipInputStream is = new ZipInputStream(new FileInputStream(file));
            while ((entry = is.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName.startsWith("META-INF/services/")) {
                    packages.add(META_INF_SERVICES);
                }
                if (entry.isDirectory() || entryName == null || entryName.length() <= 0 || entryName.startsWith(".") || !entryName.endsWith(".class") || entryName.lastIndexOf("/") <= 0) continue;
                String pkg = entryName.substring(0, entryName.lastIndexOf("/")).replace('/', '.') + version;
                packages.add(pkg);
            }
            is.close();
        }
    }

    private static List<String> listClassFiles(File directory) {
        ArrayList<String> artifacts = new ArrayList<String>();
        NodeLauncherUtil.traverse(artifacts, directory, directory);
        if (new File(directory, "META-INF/services").isDirectory()) {
            artifacts.add("META-INF/services/");
        }
        return artifacts;
    }

    private static void traverse(List<String> fileList, File file, File root) {
        if (file.isFile() && file.getName().endsWith(".class")) {
            fileList.add(root.toURI().relativize(file.toURI()).toString());
        } else if (file.isDirectory()) {
            File[] files;
            String uri = root.toURI().relativize(file.toURI()).toString();
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            fileList.add(uri);
            for (File f : files = file.listFiles()) {
                if (f.getName().startsWith(".")) continue;
                NodeLauncherUtil.traverse(fileList, f, root);
            }
        }
    }

    private static Manifest findOSGiManifest(URL jarURL) {
        try {
            Manifest manifest;
            String bundleName;
            File jarFile = new File(jarURL.toURI());
            File theManifestFile = new File(jarFile.getParent(), "META-INF/MANIFEST.MF");
            if (theManifestFile.exists() && (bundleName = (manifest = new Manifest(new FileInputStream(theManifestFile))).getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
                return manifest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Manifest thirdPartyLibraryBundleManifest(Collection<URL> jarFiles, String bundleSymbolicName, String bundleVersion) throws IllegalStateException {
        try {
            StringBuffer classpath = new StringBuffer();
            StringBuffer exports = new StringBuffer();
            StringBuffer imports = new StringBuffer();
            HashSet<String> packages = new HashSet<String>();
            for (URL jarFile : jarFiles) {
                NodeLauncherUtil.addPackages(jarFile, packages, bundleVersion);
                classpath.append("\"external:");
                classpath.append(NodeLauncherUtil.file(jarFile).getPath().replace(File.separatorChar, '/'));
                classpath.append("\",");
            }
            HashSet<String> importPackages = new HashSet<String>();
            Iterator i$ = packages.iterator();
            while (i$.hasNext()) {
                String pkg;
                String importPackage = pkg = (String)i$.next();
                int index = pkg.indexOf(59);
                if (index != -1) {
                    importPackage = pkg.substring(0, index);
                }
                if (!importPackages.contains(importPackage)) {
                    if (!"META-INF.services".equals(importPackage)) {
                        imports.append(pkg);
                        imports.append(',');
                    }
                    importPackages.add(importPackage);
                    exports.append(pkg);
                    exports.append(',');
                    continue;
                }
                logger.warning("Duplicate package skipped: " + pkg);
            }
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue("Manifest-Version", "1.0");
            attributes.putValue("Bundle-ManifestVersion", "2");
            if (bundleVersion == null) {
                bundleVersion = "0.0.0";
            }
            attributes.putValue("Bundle-Version", bundleVersion);
            if (bundleSymbolicName == null) {
                bundleSymbolicName = LAUNCHER_EQUINOX_LIBRARIES;
            }
            attributes.putValue("Bundle-SymbolicName", bundleSymbolicName);
            if (exports.length() > 0) {
                attributes.putValue("Export-Package", exports.substring(0, exports.length() - 1));
            }
            if (classpath.length() > 0) {
                attributes.putValue("Bundle-ClassPath", classpath.substring(0, classpath.length() - 1));
            }
            attributes.putValue("DynamicImport-Package", "javax.transaction;version=\"1.1\",javax.transaction.xa;version=\"1.1\",*");
            return manifest;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static InputStream thirdPartyLibraryBundle(Collection<URL> jarFiles, String bundleSymbolicName, String bundleVersion) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Manifest mf = NodeLauncherUtil.thirdPartyLibraryBundleManifest(jarFiles, bundleSymbolicName, bundleVersion);
        JarOutputStream jos = new JarOutputStream((OutputStream)bos, mf);
        jos.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    static InputStream thirdPartyLibraryBundle(Collection<URL> jarFiles, Manifest manifest) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StringBuffer classpath = new StringBuffer();
        for (URL jarFile : jarFiles) {
            classpath.append("\"external:");
            classpath.append(NodeLauncherUtil.file(jarFile).getPath().replace(File.separatorChar, '/'));
            classpath.append("\",");
        }
        if (classpath.length() > 0) {
            manifest.getMainAttributes().putValue("Bundle-ClassPath", classpath.substring(0, classpath.length() - 1));
        }
        JarOutputStream jos = new JarOutputStream((OutputStream)bos, manifest);
        jos.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    static String thisBundleLocation() throws IOException, URISyntaxException {
        String resource = NodeLauncherUtil.class.getName().replace('.', '/') + ".class";
        URL url = NodeLauncherUtil.class.getClassLoader().getResource(resource);
        if (url == null) {
            throw new FileNotFoundException(resource);
        }
        URI uri = NodeLauncherUtil.toURI(url);
        String scheme = uri.getScheme();
        if (scheme.equals("jar")) {
            String path = uri.toString().substring(4);
            int i = path.indexOf("!/");
            path = path.substring(0, i);
            return path;
        }
        String path = uri.toString();
        path = path.substring(0, path.length() - resource.length());
        return path;
    }

    static URI toURI(URL url) {
        File file = NodeLauncherUtil.file(url);
        if (file != null) {
            return file.toURI();
        }
        return NodeLauncherUtil.createURI(url.toString());
    }

    static URI createURI(String uri) {
        if (uri == null) {
            return null;
        }
        if (uri.indexOf(37) != -1) {
            return URI.create(uri);
        }
        int index = uri.indexOf(58);
        String scheme = null;
        String ssp = uri;
        if (index != -1) {
            scheme = uri.substring(0, index);
            ssp = uri.substring(index + 1);
        }
        try {
            return new URI(scheme, ssp, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static String thisBundleLocation(Bundle bundle) throws IOException, URISyntaxException, ClassNotFoundException {
        String resource = NodeLauncherUtil.class.getName();
        Class clazz = bundle.loadClass(NodeLauncherUtil.class.getName());
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (url == null) {
            throw new FileNotFoundException(resource);
        }
        URI uri = NodeLauncherUtil.toURI(url);
        String scheme = uri.getScheme();
        if (scheme.equals("jar")) {
            String path = uri.toString().substring(4);
            int i = path.indexOf("!/");
            path = path.substring(0, i);
            return path;
        }
        String path = uri.toString();
        return path;
    }

    static void fixupBundle(String location) throws BundleException, IOException {
        File target = NodeLauncherUtil.file(new URL(location));
        if (!target.exists()) {
            return;
        }
        location = target.toURI().toString();
        if (location.endsWith("/target/classes/")) {
            int l;
            File targetManifest = new File(target, "META-INF/MANIFEST.MF");
            File sourceManifest = new File(target.getParentFile().getParentFile(), "META-INF/MANIFEST.MF");
            if (!sourceManifest.isFile()) {
                return;
            }
            targetManifest.getParentFile().mkdirs();
            FileOutputStream os = new FileOutputStream(targetManifest);
            FileInputStream is = new FileInputStream(sourceManifest);
            byte[] buf = new byte[2048];
            while ((l = ((InputStream)is).read(buf)) != -1) {
                ((OutputStream)os).write(buf, 0, l);
            }
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
    }

    static String string(Bundle bundle, boolean verbose) {
        StringBuffer sb = new StringBuffer();
        sb.append(bundle.getBundleId()).append(" ").append(bundle.getSymbolicName());
        int s = bundle.getState();
        if ((s & 1) != 0) {
            sb.append(" UNINSTALLED");
        }
        if ((s & 2) != 0) {
            sb.append(" INSTALLED");
        }
        if ((s & 4) != 0) {
            sb.append(" RESOLVED");
        }
        if ((s & 8) != 0) {
            sb.append(" STARTING");
        }
        if ((s & 0x10) != 0) {
            sb.append(" STOPPING");
        }
        if ((s & 0x20) != 0) {
            sb.append(" ACTIVE");
        }
        if (verbose) {
            sb.append(" ").append(bundle.getLocation());
            sb.append(" ").append(bundle.getHeaders());
        }
        return sb.toString();
    }

    static String bundleName(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        String bundleName = null;
        if (file.isDirectory()) {
            File mf = new File(file, "META-INF/MANIFEST.MF");
            if (mf.isFile()) {
                Manifest manifest = new Manifest(new FileInputStream(mf));
                bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            } else if (file.toURI().getPath().endsWith("/target/classes/") && (mf = new File(file.getParentFile().getParentFile(), "META-INF/MANIFEST.MF")).isFile()) {
                Manifest manifest = new Manifest(new FileInputStream(mf));
                bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            }
        } else {
            JarFile jar = new JarFile(file, false);
            Manifest manifest = jar.getManifest();
            if (manifest != null) {
                bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            }
            jar.close();
        }
        if (bundleName == null) {
            return bundleName;
        }
        int sc = bundleName.indexOf(59);
        if (sc != -1) {
            bundleName = bundleName.substring(0, sc);
        }
        return bundleName;
    }

    private static void collectClasspathEntries(File directory, Set<URL> urls, FilenameFilter filter, boolean recursive) throws MalformedURLException {
        File[] files = directory.listFiles(filter);
        if (files != null) {
            int count = 0;
            for (File file : files) {
                if (recursive && file.isDirectory()) {
                    NodeLauncherUtil.collectClasspathEntries(file, urls, filter, recursive);
                    continue;
                }
                urls.add(file.toURI().toURL());
                ++count;
            }
            if (count != 0) {
                logger.fine("Runtime classpath: " + count + " JAR" + (count > 1 ? "s" : "") + " from " + directory.toString());
            }
        }
    }

    private static void collectTargetClassesClasspathEntries(File directory, Set<URL> urls, FilenameFilter filter) throws MalformedURLException {
        File[] files = directory.listFiles();
        if (files != null) {
            int count = 0;
            for (File file : files) {
                File classes;
                File target;
                if (!file.isDirectory() || !(target = new File(file, "target")).isDirectory() || !(classes = new File(target, "classes")).isDirectory() || !filter.accept(target, "classes")) continue;
                urls.add(classes.toURI().toURL());
                ++count;
            }
            if (count != 0 && logger.isLoggable(Level.FINE)) {
                logger.fine("Runtime classpath: " + count + " classes folder" + (count > 1 ? "s" : "") + " from " + directory.toString());
            }
        }
    }

    private static void collectDistributionClasspathEntries(String directory, Set<URL> jarDirectoryURLs, Set<URL> jarURLs, FilenameFilter filter) throws MalformedURLException {
        File directoryFile = new File(directory);
        URL directoryURL = directoryFile.toURI().toURL();
        if (!jarDirectoryURLs.contains(directoryURL) && directoryFile.exists()) {
            jarDirectoryURLs.add(directoryURL);
            NodeLauncherUtil.collectClasspathEntries(directoryFile, jarURLs, filter, false);
            File modulesDirectory = new File(directoryFile, "modules");
            URL modulesDirectoryURL = modulesDirectory.toURI().toURL();
            if (!jarDirectoryURLs.contains(modulesDirectoryURL) && modulesDirectory.exists()) {
                jarDirectoryURLs.add(modulesDirectoryURL);
                NodeLauncherUtil.collectClasspathEntries(modulesDirectory, jarURLs, filter, true);
            }
        }
    }

    private static boolean isMavenTestMode() {
        return NodeLauncherUtil.getProperty("surefire.test.class.path") != null || NodeLauncherUtil.getProperty("surefire.real.class.path") != null || NodeLauncherUtil.getProperty("localRepository") != null;
    }

    static Set<URL> runtimeClasspathEntries(boolean useDistribution, boolean useAppClasspath, boolean useModulesDirectory) throws FileNotFoundException, URISyntaxException, MalformedURLException {
        File modulesDirectory;
        File moduleDirectory;
        File file;
        URI uri;
        HashSet<URL> jarDirectoryURLs = new HashSet<URL>();
        HashSet<URL> jarURLs = new HashSet<URL>();
        try {
            uri = NodeLauncherUtil.codeLocation(NodeLauncherUtil.class);
        }
        catch (Exception e) {
            uri = URI.create("");
        }
        if (uri.getPath().endsWith(".jar")) {
            File jarDirectory;
            if (useDistribution && (file = new File(uri)).exists() && (jarDirectory = file.getParentFile()) != null && jarDirectory.exists()) {
                URL jarDirectoryURL = jarDirectory.toURI().toURL();
                jarDirectoryURLs.add(jarDirectoryURL);
                NodeLauncherUtil.collectClasspathEntries(jarDirectory, jarURLs, new StandAloneJARFileNameFilter(), true);
                File homeDirectory = jarDirectory.getParentFile();
                if (homeDirectory != null && homeDirectory.exists()) {
                    NodeLauncherUtil.collectDistributionClasspathEntries(homeDirectory.getAbsolutePath(), jarDirectoryURLs, jarURLs, new StandAloneJARFileNameFilter());
                }
            }
        } else if (uri.getPath().endsWith("/target/classes/") && useModulesDirectory && !NodeLauncherUtil.isMavenTestMode() && (file = new File(uri)).exists() && (moduleDirectory = file.getParentFile().getParentFile()) != null && (modulesDirectory = moduleDirectory.getParentFile()) != null && modulesDirectory.exists() && modulesDirectory.getName().equals("modules")) {
            NodeLauncherUtil.collectDevelopmentClasspathEntries(modulesDirectory.getAbsolutePath(), jarDirectoryURLs, jarURLs, new StandAloneDevelopmentClassesFileNameFilter());
            NodeLauncherUtil.collectDevelopmentLibraryEntries(modulesDirectory, jarDirectoryURLs, jarURLs);
        }
        if (useDistribution) {
            String ext;
            String home = NodeLauncherUtil.getProperty(TUSCANY_HOME);
            if (home != null && home.length() != 0) {
                logger.info("TUSCANY_HOME: " + home);
                NodeLauncherUtil.collectDistributionClasspathEntries(home, jarDirectoryURLs, jarURLs, new StandAloneJARFileNameFilter());
            }
            if ((ext = NodeLauncherUtil.getProperty(TUSCANY_PATH)) != null && ext.length() != 0) {
                logger.info("TUSCANY_PATH: " + ext);
                String separator = NodeLauncherUtil.getProperty("path.separator");
                StringTokenizer tokens = new StringTokenizer(ext, separator);
                while (tokens.hasMoreTokens()) {
                    NodeLauncherUtil.collectDistributionClasspathEntries(tokens.nextToken(), jarDirectoryURLs, jarURLs, new StandAloneJARFileNameFilter());
                }
            }
        }
        if (useAppClasspath) {
            NodeLauncherUtil.collectClassLoaderClasspathEntries(jarURLs, NodeLauncherUtil.class.getClassLoader());
        }
        return jarURLs;
    }

    static List<URL> jarFilesOnClasspath(ClassLoader classLoader) {
        HashSet<URL> entries = new HashSet<URL>();
        NodeLauncherUtil.collectClassLoaderClasspathEntries(entries, classLoader);
        return new ArrayList<URL>(entries);
    }

    private static String getProperty(final String prop) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String value = System.getProperty(prop);
                if (value == null || value.length() == 0) {
                    return System.getenv(prop);
                }
                return value;
            }
        });
    }

    private static void collectClassLoaderClasspathEntries(Set<URL> urls, ClassLoader cl) {
        URL[] jarURLs;
        if (cl == null) {
            return;
        }
        int count = urls.size();
        if (cl instanceof URLClassLoader && (jarURLs = ((URLClassLoader)cl).getURLs()) != null) {
            for (URL jarURL : jarURLs) {
                urls.add(jarURL);
                try {
                    urls.addAll(NodeLauncherUtil.manifestClassPath(jarURL));
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            count = urls.size() - count;
            if (count != 0 && logger.isLoggable(Level.FINE)) {
                logger.fine("Runtime classpath: " + count + " JAR" + (count > 1 ? "s" : "") + " from application classpath.");
            }
        }
    }

    static Set<URL> manifestClassPath(URL jarFile) throws Exception {
        HashSet<URL> urls = new HashSet<URL>();
        if (jarFile != null) {
            String cp;
            Manifest mf = null;
            if ("file".equals(jarFile.getProtocol())) {
                File f = NodeLauncherUtil.file(jarFile);
                if (f.isDirectory()) {
                    File mfFile = new File(f, "META-INF/MANIFEST.MF");
                    if (mfFile.isFile()) {
                        FileInputStream is = new FileInputStream(mfFile);
                        mf = new Manifest(is);
                        is.close();
                    }
                } else if (f.isFile()) {
                    JarInputStream jar = new JarInputStream(jarFile.openStream());
                    mf = jar.getManifest();
                    jar.close();
                }
            }
            if (mf != null && (cp = mf.getMainAttributes().getValue("Class-Path")) != null) {
                StringTokenizer st = new StringTokenizer(cp);
                while (st.hasMoreTokens()) {
                    URL entry = new URL(jarFile.toURI().toURL(), st.nextToken()).toURI().toURL();
                    urls.add(entry);
                }
            }
        }
        return urls;
    }

    static File file(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    private static URI codeLocation(Class<?> clazz) {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        return NodeLauncherUtil.toURI(url);
    }

    private static void collectDevelopmentClasspathEntries(String directory, Set<URL> jarDirectoryURLs, Set<URL> jarURLs, FilenameFilter filter) throws MalformedURLException {
        File directoryFile = new File(directory);
        URL directoryURL = directoryFile.toURI().toURL();
        if (!jarDirectoryURLs.contains(directoryURL) && directoryFile.exists()) {
            jarDirectoryURLs.add(directoryURL);
            NodeLauncherUtil.collectTargetClassesClasspathEntries(directoryFile, jarURLs, filter);
        }
    }

    private static void collectDevelopmentLibraryEntries(File modulesDirectory, Set<URL> jarDirectoryURLs, Set<URL> jarURLs) throws MalformedURLException {
        File rootDirectory = modulesDirectory.getParentFile();
        String sep = File.separator;
        File libsDirectory = new File(rootDirectory, "distribution" + sep + "all" + sep + "target" + sep + "modules");
        URL libsURL = libsDirectory.toURI().toURL();
        if (!jarDirectoryURLs.contains(libsURL) && libsDirectory.exists()) {
            jarDirectoryURLs.add(libsURL);
            NodeLauncherUtil.collectClasspathEntries(libsDirectory, jarURLs, new DistributionLibsFileNameFilter(), true);
        }
    }

    static InputStream generateGatewayBundle(Collection<String> bundleSymbolicNames, String bundleVersion, boolean reexport) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        StringBuffer requireBundle = new StringBuffer();
        for (String name : new HashSet<String>(bundleSymbolicNames)) {
            requireBundle.append(name).append(";").append("resolution").append(":=").append("optional");
            if (reexport) {
                requireBundle.append(";").append("visibility").append(":=").append("reexport");
            }
            requireBundle.append(",");
        }
        int len = requireBundle.length();
        if (len > 0 && requireBundle.charAt(len - 1) == ',') {
            requireBundle.deleteCharAt(len - 1);
            attrs.putValue("Require-Bundle", requireBundle.toString());
            attrs.putValue("Manifest-Version", "1.0");
            attrs.putValue("Implementation-Vendor", "The Apache Software Foundation");
            attrs.putValue("Implementation-Vendor-Id", "org.apache");
            if (bundleVersion != null) {
                attrs.putValue("Bundle-Version", bundleVersion);
            }
            attrs.putValue("Bundle-ManifestVersion", "2");
            attrs.putValue("Bundle-SymbolicName", GATEWAY_BUNDLE);
            attrs.putValue("Bundle-Name", "Apache Tuscany SCA Gateway Bundle");
            attrs.putValue("Bundle-Vendor", "The Apache Software Foundation");
            attrs.putValue("Export-Package", "META-INF.services");
            attrs.putValue("DynamicImport-Package", "*");
            attrs.putValue("Bundle-ActivationPolicy", "lazy");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            JarOutputStream jos = new JarOutputStream((OutputStream)bos, manifest);
            jos.close();
            return new ByteArrayInputStream(bos.toByteArray());
        }
        return null;
    }

    private static class DistributionLibsFileNameFilter
    implements FilenameFilter {
        private DistributionLibsFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (new File(dir, name = name.toLowerCase()).isDirectory()) {
                return true;
            }
            if (name.startsWith("tuscany")) {
                return name.startsWith("tuscany-sdo");
            }
            if (name.endsWith(".jar")) {
                return true;
            }
            return name.endsWith(".mar");
        }
    }

    private static class WebAppJARFileNameFilter
    extends StandAloneJARFileNameFilter {
        private WebAppJARFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (!super.accept(dir, name)) {
                return false;
            }
            if ((name = name.toLowerCase()).startsWith("servlet-api")) {
                return false;
            }
            return !name.startsWith("tuscany-host-tomcat") && !name.startsWith("tuscany-host-jetty");
        }
    }

    private static class StandAloneDevelopmentClassesFileNameFilter
    implements FilenameFilter {
        private StandAloneDevelopmentClassesFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            name = name.toLowerCase();
            if (dir.getName().equals("target") && name.equals("classes")) {
                String dirPath = dir.getAbsolutePath();
                return !dirPath.endsWith("host-tomcat/target") && !dirPath.endsWith("host-webapp/target");
            }
            if (name.startsWith("tuscany-host-tomcat") || name.startsWith("tuscany-host-webapp")) {
                return false;
            }
            if (name.endsWith(".jar")) {
                return true;
            }
            return name.endsWith(".mar");
        }
    }

    private static class StandAloneJARFileNameFilter
    implements FilenameFilter {
        private StandAloneJARFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (new File(dir, name = name.toLowerCase()).isDirectory()) {
                return true;
            }
            if (name.startsWith("tuscany-host-tomcat") || name.startsWith("tuscany-host-webapp")) {
                return false;
            }
            if (name.endsWith("-sources.jar")) {
                return false;
            }
            if (name.endsWith(".jar")) {
                return true;
            }
            return name.endsWith(".mar");
        }
    }
}

