/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.equinox.launcher;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.equinox.launcher.Contribution;
import org.apache.tuscany.sca.node.equinox.launcher.EquinoxHost;
import org.apache.tuscany.sca.node.equinox.launcher.LauncherException;
import org.apache.tuscany.sca.node.equinox.launcher.NodeLauncherUtil;
import org.osgi.framework.BundleContext;

public class NodeLauncher2 {
    static final Logger logger = Logger.getLogger(NodeLauncher2.class.getName());
    private EquinoxHost equinoxHost = new EquinoxHost();
    private BundleContext bundleContext = this.equinoxHost.start();

    private NodeLauncher2() {
    }

    public static NodeLauncher2 newInstance() {
        return new NodeLauncher2();
    }

    public <T> T createNode(String configurationURL) throws LauncherException {
        return (T)NodeLauncherUtil.node(configurationURL, null, null, null, this.bundleContext);
    }

    public <T> T createNode(String compositeURI, Contribution ... contributions) throws LauncherException {
        return (T)NodeLauncherUtil.node(null, compositeURI, null, contributions, this.bundleContext);
    }

    public <T> T createNode(String compositeURI, String compositeContent, Contribution ... contributions) throws LauncherException {
        return (T)NodeLauncherUtil.node(null, compositeURI, compositeContent, contributions, this.bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Object node;
        EquinoxHost equinox;
        block16: {
            logger.info("Apache Tuscany SCA Node is starting...");
            NodeLauncher2 launcher = NodeLauncher2.newInstance();
            equinox = launcher.equinoxHost;
            node = null;
            ShutdownThread shutdown = null;
            try {
                Contribution[] contributions = new Contribution[args.length];
                for (int i = 0; i < args.length; ++i) {
                    File f = new File(args[i]);
                    if (!f.exists()) {
                        System.err.println("contribution not found: " + f);
                        System.exit(1);
                    }
                    contributions[i] = new Contribution(f.toURI().toString(), f.toURI().toString());
                }
                node = launcher.createNode(null, contributions);
                try {
                    node.getClass().getMethod("start", new Class[0]).invoke(node, new Object[0]);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "SCA Node could not be started", e);
                    throw e;
                }
                logger.info("SCA Node is now started.");
                shutdown = new ShutdownThread(node, equinox);
                Runtime.getRuntime().addShutdownHook(shutdown);
                logger.info("Press enter to shutdown.");
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    Object lock;
                    Object object = lock = new Object();
                    synchronized (object) {
                        lock.wait();
                    }
                }
                if (shutdown == null) break block16;
                Runtime.getRuntime().removeShutdownHook(shutdown);
            }
            catch (Throwable throwable) {
                if (shutdown != null) {
                    Runtime.getRuntime().removeShutdownHook(shutdown);
                }
                if (node != null) {
                    NodeLauncher2.destroyNode(node);
                }
                if (equinox != null) {
                    equinox.stop();
                }
                throw throwable;
            }
        }
        if (node != null) {
            NodeLauncher2.destroyNode(node);
        }
        if (equinox != null) {
            equinox.stop();
        }
    }

    public void destroy() {
        if (this.equinoxHost != null) {
            this.equinoxHost.stop();
            this.bundleContext = null;
        }
    }

    private static void destroyNode(Object node) throws Exception {
        try {
            node.getClass().getMethod("stop", new Class[0]).invoke(node, new Object[0]);
            node.getClass().getMethod("destroy", new Class[0]).invoke(node, new Object[0]);
            logger.info("SCA Node is now stopped.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node could not be stopped", e);
            throw e;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private Object node;
        private EquinoxHost equinox;

        public ShutdownThread(Object node, EquinoxHost equinox) {
            this.node = node;
            this.equinox = equinox;
        }

        @Override
        public void run() {
            try {
                NodeLauncher2.destroyNode(this.node);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.equinox.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

