/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.equinox.launcher;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.tuscany.sca.node.equinox.launcher.Contribution;
import org.apache.tuscany.sca.node.equinox.launcher.EquinoxHost;
import org.apache.tuscany.sca.node.equinox.launcher.LauncherException;
import org.apache.tuscany.sca.node.equinox.launcher.NodeLauncherUtil;
import org.osgi.framework.BundleContext;

public class NodeLauncher {
    static final Logger logger = Logger.getLogger(NodeLauncher.class.getName());
    private EquinoxHost equinoxHost = new EquinoxHost();
    private BundleContext bundleContext = this.equinoxHost.start();

    private NodeLauncher() {
    }

    public static NodeLauncher newInstance() {
        return new NodeLauncher();
    }

    public <T> T createNode(String configurationURL) throws LauncherException {
        return (T)NodeLauncherUtil.node(configurationURL, null, null, null, this.bundleContext);
    }

    public <T> T createNode(String compositeURI, Contribution ... contributions) throws LauncherException {
        return (T)NodeLauncherUtil.node(null, compositeURI, null, contributions, this.bundleContext);
    }

    public <T> T createNode(String compositeURI, String compositeContent, Contribution ... contributions) throws LauncherException {
        return (T)NodeLauncherUtil.node(null, compositeURI, compositeContent, contributions, this.bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        EquinoxHost equinox;
        Object node;
        block29: {
            PosixParser parser = new PosixParser();
            Options options = NodeLauncher.getCommandLineOptions();
            CommandLine cli = parser.parse(options, args);
            node = null;
            ShutdownThread shutdown = null;
            equinox = null;
            try {
                int k;
                if (cli.hasOption("config")) {
                    System.setProperty("osgi.configuration.area", cli.getOptionValue("config"));
                }
                do {
                    NodeLauncher launcher;
                    if (cli.hasOption("node")) {
                        String configurationURI = cli.getOptionValue("node");
                        logger.info("SCA Node configuration: " + configurationURI);
                        launcher = NodeLauncher.newInstance();
                        equinox = launcher.equinoxHost;
                        node = launcher.createNode(configurationURI);
                    } else if (cli.hasOption("bundles")) {
                        String bundles = cli.getOptionValue("bundles");
                        if (bundles != null) {
                            System.setProperty("osgi.bundles", cli.getOptionValue("bundles"));
                        }
                        launcher = NodeLauncher.newInstance();
                        equinox = launcher.equinoxHost;
                    } else {
                        Iterator i$;
                        int index;
                        String compositeURI = cli.getOptionValue("composite");
                        List contribs = cli.getArgList();
                        Contribution[] contributions = null;
                        if (!contribs.isEmpty()) {
                            contributions = new Contribution[contribs.size()];
                            index = 0;
                            i$ = contribs.iterator();
                        } else {
                            HelpFormatter formatter = new HelpFormatter();
                            formatter.setSyntaxPrefix("Usage: ");
                            formatter.printHelp("java " + NodeLauncher.class.getName() + " [-config <equinoxConfiguration>]" + " [-c <compositeURI>]" + " [-b <bundles>]" + " [-t <ttl>]" + " contribution1 ... contributionN", options);
                            if (shutdown != null) {
                                Runtime.getRuntime().removeShutdownHook(shutdown);
                            }
                            if (node != null) {
                                NodeLauncher.destroyNode(node);
                            }
                            if (equinox == null) return;
                            equinox.stop();
                            return;
                        }
                        while (i$.hasNext()) {
                            String contrib = (String)i$.next();
                            logger.info("SCA contribution: " + contrib);
                            URL url = null;
                            try {
                                url = new URL(contrib);
                            }
                            catch (MalformedURLException e) {
                                url = new File(contrib).toURI().toURL();
                            }
                            contributions[index] = new Contribution("contribution-" + index, url.toString());
                            ++index;
                        }
                        logger.info("SCA composite: " + compositeURI);
                        NodeLauncher launcher2 = NodeLauncher.newInstance();
                        equinox = launcher2.equinoxHost;
                        node = launcher2.createNode(compositeURI, contributions);
                    }
                    if (node != null) {
                        logger.info("Apache Tuscany SCA Node is starting...");
                        try {
                            node.getClass().getMethod("start", new Class[0]).invoke(node, new Object[0]);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "SCA Node could not be started", e);
                            throw e;
                        }
                        logger.info("SCA Node is now started.");
                    }
                    shutdown = new ShutdownThread(node, equinox);
                    Runtime.getRuntime().addShutdownHook(shutdown);
                    long ttl = Long.parseLong(cli.getOptionValue("ttl", "-1"));
                    if (ttl >= 0L) {
                        logger.info("Waiting for " + ttl + " milliseconds ...");
                        Thread.sleep(ttl);
                        break;
                    }
                    logger.info("Press 'q' to quit, 'r' to restart.");
                    k = 0;
                    try {
                        while (k != 113 && k != 114) {
                            k = System.in.read();
                        }
                    }
                    catch (IOException e) {
                        Object lock;
                        Object object = lock = new Object();
                        synchronized (object) {
                            lock.wait();
                        }
                    }
                    if (node == null) continue;
                    Object n = node;
                    node = null;
                    NodeLauncher.stopNode(n);
                } while (k != 113);
                if (shutdown == null) break block29;
                Runtime.getRuntime().removeShutdownHook(shutdown);
            }
            catch (Throwable throwable) {
                if (shutdown != null) {
                    Runtime.getRuntime().removeShutdownHook(shutdown);
                }
                if (node != null) {
                    NodeLauncher.destroyNode(node);
                }
                if (equinox == null) throw throwable;
                equinox.stop();
                throw throwable;
            }
        }
        if (node != null) {
            NodeLauncher.destroyNode(node);
        }
        if (equinox == null) return;
        equinox.stop();
    }

    static Options getCommandLineOptions() {
        Options options = new Options();
        Option opt1 = new Option("c", "composite", true, "URI for the composite");
        opt1.setArgName("compositeURI");
        options.addOption(opt1);
        Option opt2 = new Option("n", "node", true, "URI for the node configuration");
        opt2.setArgName("nodeConfigurationURI");
        options.addOption(opt2);
        Option opt3 = new Option("config", "configuration", true, "Configuration");
        opt3.setArgName("equinoxConfiguration");
        options.addOption(opt3);
        Option opt4 = new Option("t", "ttl", true, "Time to live");
        opt4.setArgName("timeToLiveInMilliseconds");
        options.addOption(opt4);
        Option opt5 = new Option("b", "bundles", false, "OSGi bundles");
        opt4.setArgName("osgiBundles");
        options.addOption(opt5);
        return options;
    }

    public void destroy() {
        if (this.equinoxHost != null) {
            this.equinoxHost.stop();
            this.bundleContext = null;
        }
    }

    private static void destroyNode(Object node) throws Exception {
        try {
            node.getClass().getMethod("stop", new Class[0]).invoke(node, new Object[0]);
            logger.info("SCA Node is now stopped.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node could not be stopped", e);
            throw e;
        }
    }

    private static void stopNode(Object node) throws Exception {
        try {
            node.getClass().getMethod("stop", new Class[0]).invoke(node, new Object[0]);
            logger.info("SCA Node is now stopped.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node could not be stopped", e);
            throw e;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private Object node;
        private EquinoxHost equinox;

        public ShutdownThread(Object node, EquinoxHost equinox) {
            this.node = node;
            this.equinox = equinox;
        }

        @Override
        public void run() {
            try {
                NodeLauncher.destroyNode(this.node);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.equinox.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

