/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.equinox.launcher;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.equinox.launcher.EquinoxHost;
import org.apache.tuscany.sca.node.equinox.launcher.LauncherException;
import org.apache.tuscany.sca.node.equinox.launcher.NodeLauncherUtil;

public class NodeDaemonLauncher {
    static final Logger logger = Logger.getLogger(NodeDaemonLauncher.class.getName());

    private NodeDaemonLauncher() {
    }

    public static NodeDaemonLauncher newInstance() {
        return new NodeDaemonLauncher();
    }

    public <T> T createNodeDaemon() throws LauncherException {
        return (T)NodeLauncherUtil.nodeDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Object node;
        EquinoxHost equinox;
        block14: {
            logger.info("Apache Tuscany SCA Node Daemon is starting...");
            NodeDaemonLauncher launcher = NodeDaemonLauncher.newInstance();
            equinox = null;
            node = null;
            ShutdownThread shutdown = null;
            try {
                equinox = new EquinoxHost();
                equinox.start();
                node = launcher.createNodeDaemon();
                try {
                    node.getClass().getMethod("start", new Class[0]).invoke(node, new Object[0]);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "SCA Node Daemon could not be started", e);
                    throw e;
                }
                logger.info("SCA Node Daemon is now started.");
                shutdown = new ShutdownThread(node, equinox);
                Runtime.getRuntime().addShutdownHook(shutdown);
                logger.info("Press enter to shutdown.");
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    Object lock;
                    Object object = lock = new Object();
                    synchronized (object) {
                        lock.wait();
                    }
                }
                if (shutdown == null) break block14;
                Runtime.getRuntime().removeShutdownHook(shutdown);
            }
            catch (Throwable throwable) {
                if (shutdown != null) {
                    Runtime.getRuntime().removeShutdownHook(shutdown);
                }
                if (node != null) {
                    NodeDaemonLauncher.stopNode(node);
                }
                if (equinox != null) {
                    equinox.stop();
                }
                throw throwable;
            }
        }
        if (node != null) {
            NodeDaemonLauncher.stopNode(node);
        }
        if (equinox != null) {
            equinox.stop();
        }
    }

    private static void stopNode(Object node) throws Exception {
        try {
            node.getClass().getMethod("stop", new Class[0]).invoke(node, new Object[0]);
            logger.info("SCA Node Daemon is now stopped.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Node Daemon could not be stopped", e);
            throw e;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private Object node;
        private EquinoxHost equinox;

        public ShutdownThread(Object node, EquinoxHost equinox) {
            this.node = node;
            this.equinox = equinox;
        }

        @Override
        public void run() {
            try {
                NodeDaemonLauncher.stopNode(this.node);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.equinox.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

