/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.equinox.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.equinox.launcher.EquinoxHost;
import org.apache.tuscany.sca.node.equinox.launcher.NodeLauncherCommand;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class FrameworkLauncher
implements BundleActivator {
    private static final String FACTORY_RESOURCE = "META-INF/services/" + FrameworkFactory.class.getName();
    private static final Logger logger = Logger.getLogger(FrameworkLauncher.class.getName());
    private FrameworkFactory factory;
    private boolean isEquinox;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FrameworkFactory loadFrameworkFactory() {
        if (this.factory == null) {
            try {
                ClassLoader classLoader = FrameworkFactory.class.getClassLoader();
                InputStream is = classLoader.getResourceAsStream(FACTORY_RESOURCE);
                if (is == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                    is = classLoader.getResourceAsStream(FACTORY_RESOURCE);
                }
                if (is == null) {
                    return null;
                }
                BufferedReader reader = null;
                String line = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    do {
                        if ((line = reader.readLine()) != null) continue;
                        break;
                    } while ((line = line.trim()).startsWith("#") || "".equals(line));
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (line != null) {
                    Class<?> factoryImplClass = Class.forName(line, false, classLoader);
                    this.factory = (FrameworkFactory)factoryImplClass.newInstance();
                    if (this.factory != null && this.factory.getClass().getName().startsWith("org.eclipse.osgi.")) {
                        this.isEquinox = true;
                    }
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.factory;
    }

    public Framework newFramework(Map properties) {
        InputStream is;
        FrameworkFactory factory = this.loadFrameworkFactory();
        if (factory == null) {
            return null;
        }
        String propertyFile = null;
        String factoryName = factory.getClass().getName();
        if (factoryName.startsWith("org.eclipse.osgi.")) {
            propertyFile = "equinox.properties";
        } else if (factoryName.startsWith("org.apache.felix.")) {
            propertyFile = "felix.properties";
        }
        HashMap<Object, Object> propMap = new HashMap<Object, Object>();
        if (propertyFile != null && (is = this.getClass().getResourceAsStream(propertyFile)) != null) {
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            propMap.putAll(props);
        }
        propMap.putAll(properties);
        return factory.newFramework(propMap);
    }

    public boolean isEquinox() {
        return this.isEquinox;
    }

    public void start(BundleContext context) throws Exception {
        EquinoxHost.injectedBundleContext = context;
        if (context.getClass().getName().startsWith("org.eclipse.osgi.")) {
            this.isEquinox = true;
            try {
                context.registerService(CommandProvider.class.getName(), (Object)new NodeLauncherCommand(), new Hashtable());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        EquinoxHost.injectedBundleContext = null;
    }

    public static String substVars(String val, String currentKey, Map cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = FrameworkLauncher.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }
}

