/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.equinox.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.equinox.launcher.FrameworkLauncher;
import org.apache.tuscany.sca.node.equinox.launcher.NodeLauncherUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public class EquinoxHost {
    static final String PROP_OSGI_CONTEXT_CLASS_LOADER_PARENT = "osgi.contextClassLoaderParent";
    static final String PROP_OSGI_CLEAN = "osgi.clean";
    static final String PROP_USER_NAME = "user.name";
    private static Logger logger = Logger.getLogger(EquinoxHost.class.getName());
    static final String PROP_INSTALL_AREA = "osgi.install.area";
    static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    static final String PROP_INSTANCE_AREA_DEFAULT = "osgi.instance.area.default";
    static final String PROP_USER_AREA = "osgi.user.area";
    static final String PROP_USER_AREA_DEFAULT = "osgi.user.area.default";
    static BundleContext injectedBundleContext;
    private BundleContext bundleContext;
    private Bundle launcherBundle;
    private List<URL> bundleFiles = new ArrayList<URL>();
    private List<String> bundleNames = new ArrayList<String>();
    private Map<URL, Manifest> jarFiles = new HashMap<URL, Manifest>();
    private Map<String, Bundle> allBundles = new HashMap<String, Bundle>();
    private List<Bundle> installedBundles = new ArrayList<Bundle>();
    private Set<URL> bundleLocations;
    private boolean aggregateThirdPartyJars = false;
    private FrameworkLauncher frameworkLauncher = new FrameworkLauncher();
    private Framework framework;

    public EquinoxHost() {
    }

    public EquinoxHost(Set<URL> urls) {
        this.bundleLocations = urls;
    }

    private static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    private static Properties getSystemProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                Properties props = new Properties();
                for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                    String prop;
                    if (!(e.getKey() instanceof String) || !(prop = (String)e.getKey()).startsWith("osgi.") && !prop.startsWith("eclipse.")) continue;
                    props.put(prop, e.getValue());
                }
                return props;
            }
        });
    }

    private static void put(Properties props, String key, String value) {
        if (!props.contains(key)) {
            props.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getCustomizedMF(String fileName) throws IOException {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        String mf = fileName.substring(0, index) + ".MF";
        InputStream is = this.getClass().getResourceAsStream(mf);
        if (is == null) {
            return null;
        }
        try {
            Manifest manifest;
            Manifest manifest2 = manifest = new Manifest(is);
            return manifest2;
        }
        finally {
            is.close();
        }
    }

    public BundleContext start() {
        try {
            String extensibilityBundleName;
            Bundle extensibilityBundle;
            if (injectedBundleContext == null) {
                Properties props = this.configureProperties();
                this.startFramework(props);
            } else {
                this.bundleContext = injectedBundleContext;
            }
            Set<URL> urls = this.findBundleLocations();
            for (URL url : urls) {
                File file = NodeLauncherUtil.file(url);
                Manifest manifest = this.getCustomizedMF(file.getName());
                String bundleName = null;
                if (manifest == null) {
                    bundleName = NodeLauncherUtil.bundleName(file);
                } else if (manifest.getMainAttributes().getValue("Bundle-SymbolicName") == null) {
                    manifest = null;
                }
                if (bundleName != null) {
                    this.bundleFiles.add(url);
                    this.bundleNames.add(bundleName);
                    continue;
                }
                if (!file.isFile()) continue;
                this.jarFiles.put(url, manifest);
            }
            for (Bundle bundle : this.bundleContext.getBundles()) {
                this.allBundles.put(bundle.getSymbolicName(), bundle);
            }
            String launcherBundleName = "org.apache.tuscany.sca.node.launcher.equinox";
            this.launcherBundle = this.allBundles.get(launcherBundleName);
            if (this.launcherBundle == null) {
                String launcherBundleLocation = NodeLauncherUtil.thisBundleLocation();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Installing launcher bundle: " + launcherBundleLocation);
                }
                NodeLauncherUtil.fixupBundle(launcherBundleLocation);
                this.launcherBundle = this.bundleContext.installBundle(launcherBundleLocation);
                this.allBundles.put(launcherBundleName, this.launcherBundle);
                this.installedBundles.add(this.launcherBundle);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Launcher bundle is already installed: " + NodeLauncherUtil.string(this.launcherBundle, false));
            }
            System.setProperty("commonj.sdo.impl.HelperProvider", "org.apache.tuscany.sdo.helper.HelperProviderImpl");
            long start = System.currentTimeMillis();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Generating third-party library bundle.");
            }
            logger.info("Checking for manfiests customized by Tuscany in node-launcher-equinox/resources");
            long libraryStart = System.currentTimeMillis();
            HashSet<String> serviceProviders = new HashSet<String>();
            if (!this.aggregateThirdPartyJars) {
                for (Map.Entry<URL, Manifest> entry : this.jarFiles.entrySet()) {
                    URL jarFile = entry.getKey();
                    Manifest manifest = entry.getValue();
                    Bundle bundle = null;
                    bundle = manifest == null ? this.installAsBundle(jarFile, null) : this.installAsBundle(Collections.singleton(jarFile), manifest);
                    this.isServiceProvider(bundle, serviceProviders);
                }
            } else {
                Bundle bundle = this.installAsBundle(this.jarFiles.keySet(), "org.apache.tuscany.sca.node.launcher.equinox.libraries");
                this.isServiceProvider(bundle, serviceProviders);
            }
            this.installGatewayBundle(serviceProviders);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Third-party library bundle installed in " + (System.currentTimeMillis() - libraryStart) + " ms: ");
            }
            for (URL bundleFile : this.bundleFiles) {
                NodeLauncherUtil.fixupBundle(bundleFile.toString());
            }
            int n = this.bundleFiles.size();
            for (int i = 0; i < n; ++i) {
                URL bundleFile = this.bundleFiles.get(i);
                String bundleName = this.bundleNames.get(i);
                if (bundleName.contains("org.eclipse.jdt.junit") || bundleName.contains("org.apache.tuscany.sca.base")) continue;
                this.installBundle(bundleFile, bundleName);
            }
            long end = System.currentTimeMillis();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Tuscany bundles are installed in " + (end - start) + " ms.");
            }
            if ((extensibilityBundle = this.allBundles.get(extensibilityBundleName = "org.apache.tuscany.sca.extensibility.equinox")) != null) {
                if ((extensibilityBundle.getState() & 0x20) == 0) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Starting bundle: " + NodeLauncherUtil.string(extensibilityBundle, false));
                    }
                    extensibilityBundle.start();
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Bundle is already started: " + NodeLauncherUtil.string(extensibilityBundle, false));
                }
            }
            if ((this.launcherBundle.getState() & 0x20) == 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Starting launcher bundle: " + NodeLauncherUtil.string(this.launcherBundle, false));
                }
                this.launcherBundle.start();
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Bundle is already started: " + NodeLauncherUtil.string(this.launcherBundle, false));
            }
            return this.bundleContext;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected Properties configureProperties() throws IOException, FileNotFoundException {
        String version = EquinoxHost.getSystemProperty("java.specification.version");
        String profile = "J2SE-1.5.profile";
        if (version.startsWith("1.6")) {
            profile = "JavaSE-1.6.profile";
        }
        if (version.startsWith("1.7")) {
            profile = "JavaSE-1.7.profile";
        }
        Properties props = new Properties();
        InputStream is = this.getClass().getResourceAsStream(profile);
        if (is != null) {
            props.load(is);
            is.close();
        }
        props.putAll((Map<?, ?>)EquinoxHost.getSystemProperties());
        EquinoxHost.put(props, PROP_OSGI_CONTEXT_CLASS_LOADER_PARENT, "app");
        EquinoxHost.put(props, PROP_OSGI_CLEAN, "true");
        String tmpDir = EquinoxHost.getSystemProperty("java.io.tmpdir");
        File root = new File(tmpDir);
        String userName = EquinoxHost.getSystemProperty(PROP_USER_NAME);
        if (userName != null) {
            root = new File(root, userName);
        }
        root = new File(root, ".tuscany/equinox/" + UUID.randomUUID().toString());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Equinox location: " + root);
        }
        EquinoxHost.put(props, PROP_INSTANCE_AREA_DEFAULT, new File(root, "workspace").toURI().toString());
        EquinoxHost.put(props, PROP_INSTALL_AREA, new File(root, "install").toURI().toString());
        EquinoxHost.put(props, PROP_CONFIG_AREA_DEFAULT, new File(root, "config").toURI().toString());
        EquinoxHost.put(props, PROP_USER_AREA_DEFAULT, new File(root, "user").toURI().toString());
        if (this.bundleLocations == null) {
            if (props.getProperty("osgi.bundles") != null) {
                this.bundleLocations = Collections.emptySet();
            } else {
                String config = props.getProperty(PROP_CONFIG_AREA);
                File ini = new File(config, "config.ini");
                if (ini.isFile()) {
                    Properties iniProps = new Properties();
                    iniProps.load(new FileInputStream(ini));
                    if (iniProps.getProperty("osgi.bundles") != null) {
                        this.bundleLocations = Collections.emptySet();
                    }
                }
            }
        }
        return props;
    }

    private boolean isServiceProvider(Bundle bundle, Set<String> serviceProviders) {
        String export;
        if (bundle != null && (export = (String)bundle.getHeaders().get("Export-Package")) != null && export.contains("META-INF.services;partial=true;mandatory:=partial")) {
            serviceProviders.add(bundle.getSymbolicName());
            return true;
        }
        return false;
    }

    private void installGatewayBundle(Set<String> bundles) throws IOException, BundleException {
        InputStream gateway;
        if (this.allBundles.containsKey("org.apache.tuscany.sca.gateway")) {
            return;
        }
        if (bundles == null) {
            bundles = this.allBundles.keySet();
        }
        if ((gateway = NodeLauncherUtil.generateGatewayBundle(bundles, null, false)) != null) {
            Bundle gatewayBundle = this.bundleContext.installBundle("org.apache.tuscany.sca.gateway", gateway);
            this.allBundles.put("org.apache.tuscany.sca.gateway", gatewayBundle);
            this.installedBundles.add(gatewayBundle);
        }
    }

    private void startBundles(BundleContext bundleContext) {
        for (Bundle bundle : bundleContext.getBundles()) {
            if ((bundle.getState() & 0x20) != 0) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting bundle: " + NodeLauncherUtil.string(bundle, false));
            }
            try {
                bundle.start();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Bundle: " + NodeLauncherUtil.string(bundle, false));
        }
        logger.fine("Tuscany bundles are started.");
    }

    public Bundle installAsBundle(Collection<URL> jarFiles, String libraryBundleName) throws IOException, BundleException {
        Bundle libraryBundle = this.allBundles.get(libraryBundleName);
        if (libraryBundle == null) {
            InputStream library = NodeLauncherUtil.thirdPartyLibraryBundle(jarFiles, libraryBundleName, null);
            libraryBundle = this.bundleContext.installBundle(libraryBundleName, library);
            this.allBundles.put(libraryBundleName, libraryBundle);
            this.installedBundles.add(libraryBundle);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Third-party library bundle is already installed: " + NodeLauncherUtil.string(libraryBundle, false));
        }
        return libraryBundle;
    }

    public Bundle installAsBundle(Collection<URL> jarFiles, Manifest manifest) throws IOException, BundleException {
        String bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        Bundle libraryBundle = this.allBundles.get(bundleName);
        if (libraryBundle == null) {
            InputStream library = NodeLauncherUtil.thirdPartyLibraryBundle(jarFiles, manifest);
            libraryBundle = this.bundleContext.installBundle(bundleName, library);
            this.allBundles.put(bundleName, libraryBundle);
            this.installedBundles.add(libraryBundle);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Third-party library bundle is already installed: " + NodeLauncherUtil.string(libraryBundle, false));
        }
        return libraryBundle;
    }

    public Bundle installBundle(URL bundleFile, String bundleName) throws MalformedURLException, BundleException {
        Bundle bundle;
        if (bundleName == null) {
            try {
                bundleName = NodeLauncherUtil.bundleName(NodeLauncherUtil.file(bundleFile));
            }
            catch (IOException e) {
                bundleName = null;
            }
        }
        if ((bundle = this.allBundles.get(bundleName)) == null) {
            long installStart = System.currentTimeMillis();
            String location = bundleFile.toString();
            if (this.frameworkLauncher.isEquinox() && "file".equals(bundleFile.getProtocol())) {
                File target = NodeLauncherUtil.file(bundleFile);
                location = "reference:file:/" + target.getPath();
            }
            bundle = this.bundleContext.installBundle(location);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Bundle " + bundleFile + " installed in " + (System.currentTimeMillis() - installStart) + " ms: " + NodeLauncherUtil.string(bundle, false));
            }
            this.allBundles.put(bundleName, bundle);
            this.installedBundles.add(bundle);
        }
        return bundle;
    }

    public Bundle installAsBundle(URL jarFile, String symbolicName) throws IOException, BundleException {
        Bundle bundle;
        if (symbolicName == null) {
            symbolicName = "org.apache.tuscany.sca.node.launcher.equinox.libraries." + NodeLauncherUtil.artifactId(jarFile);
        }
        if ((bundle = this.allBundles.get(symbolicName)) == null) {
            String version = NodeLauncherUtil.jarVersion(jarFile);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Installing third-party jar as bundle: " + jarFile);
            }
            InputStream is = NodeLauncherUtil.thirdPartyLibraryBundle(Collections.singleton(jarFile), symbolicName, version);
            try {
                bundle = this.bundleContext.installBundle(symbolicName, is);
                this.allBundles.put(symbolicName, bundle);
                this.installedBundles.add(bundle);
            }
            catch (BundleException e) {
                System.out.println("EquinoxHost:installAsBundle - BundleException raised when dealing with jar " + symbolicName);
                throw e;
            }
        }
        return bundle;
    }

    private Set<URL> findBundleLocations() throws FileNotFoundException, URISyntaxException, MalformedURLException {
        if (this.bundleLocations == null || this.bundleLocations != null && this.bundleLocations.size() == 0) {
            this.bundleLocations = injectedBundleContext != null ? NodeLauncherUtil.runtimeClasspathEntries(true, false, true) : NodeLauncherUtil.runtimeClasspathEntries(true, true, true);
        }
        return this.bundleLocations;
    }

    public void stop() {
        try {
            for (int i = this.installedBundles.size() - 1; i >= 0; --i) {
                Bundle bundle = this.installedBundles.get(i);
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Uninstalling bundle: " + NodeLauncherUtil.string(bundle, false));
                    }
                    bundle.uninstall();
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            this.installedBundles.clear();
            this.stopFramework();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void startFramework(Map configuration) throws Exception {
        if (this.framework != null) {
            throw new IllegalStateException("The OSGi framework has been started");
        }
        this.framework = this.frameworkLauncher.newFramework(configuration);
        this.framework.start();
        this.bundleContext = this.framework.getBundleContext();
    }

    private void stopFramework() throws Exception {
        if (injectedBundleContext == null) {
            this.framework.stop();
            this.framework.waitForStop(5000L);
            this.framework = null;
            this.bundleContext = null;
        }
    }

    public void setBundleLocations(Set<URL> bundleLocations) {
        this.bundleLocations = bundleLocations;
    }

    static {
        if (EquinoxHost.getSystemProperty("osgi.debug") != null) {
            logger.setLevel(Level.FINE);
        }
    }
}

