/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.equinox.launcher;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.equinox.launcher.EquinoxHost;
import org.apache.tuscany.sca.node.equinox.launcher.LauncherException;
import org.apache.tuscany.sca.node.equinox.launcher.NodeLauncherUtil;

public class DomainManagerLauncher {
    static final Logger logger = Logger.getLogger(DomainManagerLauncher.class.getName());

    private DomainManagerLauncher() {
    }

    public static DomainManagerLauncher newInstance() {
        return new DomainManagerLauncher();
    }

    public <T> T createDomainManager() throws LauncherException {
        return (T)NodeLauncherUtil.domainManager(".");
    }

    public <T> T createDomainManager(String rootDirectory) throws LauncherException {
        return (T)NodeLauncherUtil.domainManager(rootDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Object domainManager;
        EquinoxHost equinox;
        block14: {
            logger.info("Apache Tuscany SCA Domain Manager is starting...");
            DomainManagerLauncher launcher = DomainManagerLauncher.newInstance();
            equinox = null;
            domainManager = null;
            Thread shutdown = null;
            try {
                equinox = new EquinoxHost();
                equinox.start();
                domainManager = launcher.createDomainManager();
                try {
                    domainManager.getClass().getMethod("start", new Class[0]).invoke(domainManager, new Object[0]);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "SCA Domain Manager could not be started", e);
                    throw e;
                }
                logger.info("SCA Domain Manager is now started.");
                ShutdownThread hook = new ShutdownThread(domainManager, equinox);
                Runtime.getRuntime().addShutdownHook(hook);
                logger.info("Press enter to shutdown.");
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    Object lock;
                    Object object = lock = new Object();
                    synchronized (object) {
                        lock.wait();
                    }
                }
                if (shutdown == null) break block14;
                Runtime.getRuntime().removeShutdownHook(shutdown);
            }
            catch (Throwable throwable) {
                if (shutdown != null) {
                    Runtime.getRuntime().removeShutdownHook(shutdown);
                }
                if (domainManager != null) {
                    DomainManagerLauncher.stopDomainManager(domainManager);
                }
                if (equinox != null) {
                    equinox.stop();
                }
                throw throwable;
            }
        }
        if (domainManager != null) {
            DomainManagerLauncher.stopDomainManager(domainManager);
        }
        if (equinox != null) {
            equinox.stop();
        }
    }

    private static void stopDomainManager(Object domainManager) throws Exception {
        try {
            domainManager.getClass().getMethod("stop", new Class[0]).invoke(domainManager, new Object[0]);
            logger.info("SCA Domain Manager is now stopped.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Domain Manager could not be stopped", e);
            throw e;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private Object domainManager;
        private EquinoxHost equinox;

        public ShutdownThread(Object domainManager, EquinoxHost equinox) {
            this.domainManager = domainManager;
            this.equinox = equinox;
        }

        @Override
        public void run() {
            try {
                DomainManagerLauncher.stopDomainManager(this.domainManager);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.equinox.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

