/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.monitor.impl;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.tuscany.sca.monitor.Problem;

public class ProblemImpl
implements Problem {
    private String sourceClassName;
    private String bundleName;
    private Problem.Severity severity;
    private Object problemObject;
    private String messageId;
    private Object[] messageParams;
    private Exception cause;

    public ProblemImpl(String sourceClassName, String bundleName, Problem.Severity severity, Object problemObject, String messageId, Object ... messageParams) {
        this.sourceClassName = sourceClassName;
        this.bundleName = bundleName;
        this.severity = severity;
        this.problemObject = problemObject;
        this.messageId = messageId;
        this.messageParams = messageParams;
    }

    public ProblemImpl(String sourceClassName, String bundleName, Problem.Severity severity, Object problemObject, String messageId, Exception cause) {
        this.sourceClassName = sourceClassName;
        this.bundleName = bundleName;
        this.severity = severity;
        this.problemObject = problemObject;
        this.messageId = messageId;
        this.cause = cause;
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public Problem.Severity getSeverity() {
        return this.severity;
    }

    public Object getProblemObject() {
        return this.problemObject;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Object[] getMessageParams() {
        return this.messageParams;
    }

    public Exception getCause() {
        return this.cause;
    }

    public String toString() {
        Logger logger = Logger.getLogger(this.sourceClassName, this.bundleName);
        LogRecord record = new LogRecord(Level.INFO, this.messageId);
        if (this.cause == null) {
            record.setParameters(this.messageParams);
        } else {
            Object[] params = new String[]{this.cause.toString()};
            record.setParameters(params);
        }
        record.setResourceBundle(logger.getResourceBundle());
        record.setSourceClassName(this.sourceClassName);
        SimpleFormatter formatter = new SimpleFormatter();
        return formatter.formatMessage(record);
    }
}

