/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.monitor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorImpl
implements Monitor {
    private static final Logger logger = Logger.getLogger(MonitorImpl.class.getName());
    private List<Problem> problemCache = new ArrayList<Problem>();

    @Override
    public void problem(Problem problem) {
        Logger problemLogger = Logger.getLogger(problem.getSourceClassName(), problem.getBundleName());
        if (problemLogger == null) {
            logger.severe("Can't get logger " + problem.getSourceClassName() + " with bundle " + problem.getBundleName());
        }
        if (problem.getSeverity() == Problem.Severity.INFO) {
            this.problemCache.add(problem);
            problemLogger.logp(Level.INFO, problem.getSourceClassName(), (String)null, problem.getMessageId(), problem.getMessageParams());
        } else if (problem.getSeverity() == Problem.Severity.WARNING) {
            this.problemCache.add(problem);
            problemLogger.logp(Level.WARNING, problem.getSourceClassName(), (String)null, problem.getMessageId(), problem.getMessageParams());
        } else if (problem.getSeverity() == Problem.Severity.ERROR) {
            if (problem.getCause() != null) {
                this.problemCache.add(problem);
                problemLogger.logp(Level.SEVERE, problem.getSourceClassName(), null, problem.getMessageId(), problem.getCause().toString());
            } else {
                this.problemCache.add(problem);
                problemLogger.logp(Level.SEVERE, problem.getSourceClassName(), (String)null, problem.getMessageId(), problem.getMessageParams());
            }
        }
    }

    @Override
    public List<Problem> getProblems() {
        return this.problemCache;
    }

    @Override
    public Problem getLastProblem() {
        if (this.problemCache.isEmpty()) {
            return null;
        }
        return this.problemCache.get(this.problemCache.size() - 1);
    }

    @Override
    public Problem createProblem(String sourceClassName, String bundleName, Problem.Severity severity, Object problemObject, String messageId, Exception cause) {
        return new ProblemImpl(sourceClassName, bundleName, severity, problemObject, messageId, cause);
    }

    @Override
    public Problem createProblem(String sourceClassName, String bundleName, Problem.Severity severity, Object problemObject, String messageId, Object ... messageParams) {
        return new ProblemImpl(sourceClassName, bundleName, severity, problemObject, messageId, messageParams);
    }
}

