/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.xml.JavaConstants;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaInterfaceProcessor
implements StAXArtifactProcessor<JavaInterfaceContract>,
JavaConstants {
    private JavaInterfaceFactory javaFactory;
    private Monitor monitor;

    public JavaInterfaceProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.javaFactory = (JavaInterfaceFactory)modelFactories.getFactory(JavaInterfaceFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "interface-javaxml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "interface-javaxml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private JavaInterface createJavaInterface(String interfaceName) {
        JavaInterface javaInterface = this.javaFactory.createJavaInterface();
        javaInterface.setUnresolved(true);
        javaInterface.setName(interfaceName);
        return javaInterface;
    }

    public JavaInterfaceContract read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String callbackInterfaceName;
        JavaInterfaceContract javaInterfaceContract = this.javaFactory.createJavaInterfaceContract();
        String interfaceName = reader.getAttributeValue(null, "interface");
        if (interfaceName != null) {
            JavaInterface javaInterface = this.createJavaInterface(interfaceName);
            javaInterfaceContract.setInterface((Interface)javaInterface);
        }
        if ((callbackInterfaceName = reader.getAttributeValue(null, "callbackInterface")) != null) {
            JavaInterface javaCallbackInterface = this.createJavaInterface(callbackInterfaceName);
            javaInterfaceContract.setCallbackInterface((Interface)javaCallbackInterface);
        }
        while (reader.hasNext() && (reader.next() != 2 || !INTERFACE_JAVA_QNAME.equals(reader.getName()))) {
        }
        return javaInterfaceContract;
    }

    public void write(JavaInterfaceContract javaInterfaceContract, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        JavaInterface javaCallbackInterface;
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "interface.java");
        JavaInterface javaInterface = (JavaInterface)javaInterfaceContract.getInterface();
        if (javaInterface != null && javaInterface.getName() != null) {
            writer.writeAttribute("interface", javaInterface.getName());
        }
        if ((javaCallbackInterface = (JavaInterface)javaInterfaceContract.getCallbackInterface()) != null && javaCallbackInterface.getName() != null) {
            writer.writeAttribute("callbackInterface", javaCallbackInterface.getName());
        }
        writer.writeEndElement();
    }

    private JavaInterface resolveJavaInterface(JavaInterface javaInterface, ModelResolver resolver) throws ContributionResolveException {
        if (javaInterface != null && javaInterface.isUnresolved() && (javaInterface = (JavaInterface)resolver.resolveModel(JavaInterface.class, (Object)javaInterface)).isUnresolved()) {
            ClassReference classReference = new ClassReference(javaInterface.getName());
            Class javaClass = (classReference = (ClassReference)resolver.resolveModel(ClassReference.class, (Object)classReference)).getJavaClass();
            if (javaClass == null) {
                this.error("ClassNotFoundException", (Object)resolver, javaInterface.getName());
                return javaInterface;
            }
            try {
                this.javaFactory.createJavaInterface(javaInterface, javaClass);
            }
            catch (InvalidInterfaceException e) {
                ContributionResolveException ce = new ContributionResolveException((Throwable)e);
                this.error("ContributionResolveException", (Object)this.javaFactory, (Exception)ce);
                return javaInterface;
            }
            javaInterface.setUnresolved(false);
            resolver.addModel((Object)javaInterface);
        }
        return javaInterface;
    }

    public void resolve(JavaInterfaceContract javaInterfaceContract, ModelResolver resolver) throws ContributionResolveException {
        JavaInterface javaInterface = this.resolveJavaInterface((JavaInterface)javaInterfaceContract.getInterface(), resolver);
        javaInterfaceContract.setInterface((Interface)javaInterface);
        JavaInterface javaCallbackInterface = this.resolveJavaInterface((JavaInterface)javaInterfaceContract.getCallbackInterface(), resolver);
        javaInterfaceContract.setCallbackInterface((Interface)javaCallbackInterface);
    }

    public QName getArtifactType() {
        return INTERFACE_JAVA_QNAME;
    }

    public Class<JavaInterfaceContract> getModelType() {
        return JavaInterfaceContract.class;
    }
}

