/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.embedded.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.EndpointFactory;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.DefaultModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionService;
import org.apache.tuscany.sca.core.DefaultExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.ActivationException;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.core.scope.ScopeRegistry;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.definitions.impl.SCADefinitionsImpl;
import org.apache.tuscany.sca.definitions.util.SCADefinitionsUtil;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.host.embedded.impl.ReallySmallRuntimeBuilder;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.impl.DefaultMonitorFactoryImpl;
import org.apache.tuscany.sca.policy.DefaultIntentAttachPointTypeFactory;
import org.apache.tuscany.sca.policy.DefaultPolicyFactory;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.IntentAttachPointTypeFactory;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.provider.SCADefinitionsProvider;
import org.apache.tuscany.sca.provider.SCADefinitionsProviderExtensionPoint;
import org.apache.tuscany.sca.work.WorkScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReallySmallRuntime {
    private static final Logger logger = Logger.getLogger(ReallySmallRuntime.class.getName());
    private List<ModuleActivator> modules;
    private ExtensionPointRegistry registry;
    private ClassLoader classLoader;
    private AssemblyFactory assemblyFactory;
    private ContributionService contributionService;
    private CompositeActivator compositeActivator;
    private CompositeBuilder compositeBuilder;
    private WorkScheduler workScheduler;
    private ScopeRegistry scopeRegistry;
    private ProxyFactory proxyFactory;
    private List<SCADefinitions> policyDefinitions;
    private ModelResolver policyDefinitionsResolver;
    private Monitor monitor;

    public ReallySmallRuntime(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void start() throws ActivationException {
        long start = System.currentTimeMillis();
        this.registry = new DefaultExtensionPointRegistry();
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)this.registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.workScheduler = (WorkScheduler)utilities.getUtility(WorkScheduler.class);
        InterfaceContractMapper mapper = (InterfaceContractMapper)utilities.getUtility(InterfaceContractMapper.class);
        ModelFactoryExtensionPoint factories = (ModelFactoryExtensionPoint)this.registry.getExtensionPoint(ModelFactoryExtensionPoint.class);
        MessageFactory messageFactory = (MessageFactory)factories.getFactory(MessageFactory.class);
        ProxyFactoryExtensionPoint proxyFactories = (ProxyFactoryExtensionPoint)this.registry.getExtensionPoint(ProxyFactoryExtensionPoint.class);
        this.proxyFactory = new ExtensibleProxyFactory(proxyFactories);
        this.assemblyFactory = new RuntimeAssemblyFactory();
        factories.addFactory((Object)this.assemblyFactory);
        DefaultPolicyFactory policyFactory = new DefaultPolicyFactory();
        factories.addFactory((Object)policyFactory);
        this.modules = this.loadModules(this.registry);
        this.startModules(this.registry, this.modules);
        SCABindingFactory scaBindingFactory = (SCABindingFactory)factories.getFactory(SCABindingFactory.class);
        DefaultIntentAttachPointTypeFactory intentAttachPointTypeFactory = new DefaultIntentAttachPointTypeFactory();
        factories.addFactory((Object)intentAttachPointTypeFactory);
        ContributionFactory contributionFactory = (ContributionFactory)factories.getFactory(ContributionFactory.class);
        MonitorFactory monitorFactory = (MonitorFactory)utilities.getUtility(MonitorFactory.class);
        if (monitorFactory != null) {
            this.monitor = monitorFactory.createMonitor();
        } else {
            monitorFactory = new DefaultMonitorFactoryImpl();
            this.monitor = monitorFactory.createMonitor();
            utilities.addUtility((Object)monitorFactory);
        }
        this.policyDefinitions = new ArrayList<SCADefinitions>();
        this.policyDefinitionsResolver = new DefaultModelResolver();
        this.contributionService = ReallySmallRuntimeBuilder.createContributionService(this.classLoader, this.registry, contributionFactory, this.assemblyFactory, (PolicyFactory)policyFactory, mapper, this.policyDefinitions, this.policyDefinitionsResolver, this.monitor);
        this.scopeRegistry = ReallySmallRuntimeBuilder.createScopeRegistry(this.registry);
        this.compositeActivator = ReallySmallRuntimeBuilder.createCompositeActivator(this.registry, this.assemblyFactory, messageFactory, scaBindingFactory, mapper, this.proxyFactory, this.scopeRegistry, this.workScheduler);
        this.loadSCADefinitions();
        if (logger.isLoggable(Level.FINE)) {
            long end = System.currentTimeMillis();
            logger.fine("The tuscany runtime is started in " + (end - start) + " ms.");
        }
    }

    public void stop() throws ActivationException {
        long start = System.currentTimeMillis();
        this.stopModules(this.registry, this.modules);
        this.workScheduler.destroy();
        this.modules = null;
        this.registry = null;
        this.assemblyFactory = null;
        this.contributionService = null;
        this.compositeActivator = null;
        this.workScheduler = null;
        this.scopeRegistry = null;
        if (logger.isLoggable(Level.FINE)) {
            long end = System.currentTimeMillis();
            logger.fine("The tuscany runtime is stopped in " + (end - start) + " ms.");
        }
    }

    public void buildComposite(Composite composite) throws CompositeBuilderException {
        ModelFactoryExtensionPoint factories = (ModelFactoryExtensionPoint)this.registry.getExtensionPoint(ModelFactoryExtensionPoint.class);
        SCABindingFactory scaBindingFactory = (SCABindingFactory)factories.getFactory(SCABindingFactory.class);
        IntentAttachPointTypeFactory intentAttachPointTypeFactory = (IntentAttachPointTypeFactory)factories.getFactory(IntentAttachPointTypeFactory.class);
        EndpointFactory endpointFactory = (EndpointFactory)factories.getFactory(EndpointFactory.class);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)this.registry.getExtensionPoint(UtilityExtensionPoint.class);
        InterfaceContractMapper mapper = (InterfaceContractMapper)utilities.getUtility(InterfaceContractMapper.class);
        DocumentBuilderFactory documentBuilderFactory = (DocumentBuilderFactory)factories.getFactory(DocumentBuilderFactory.class);
        TransformerFactory transformerFactory = (TransformerFactory)factories.getFactory(TransformerFactory.class);
        SCADefinitionsImpl aggregatedDefinitions = new SCADefinitionsImpl();
        for (SCADefinitions definition : this.policyDefinitions) {
            SCADefinitionsUtil.aggregateSCADefinitions((SCADefinitions)definition, (SCADefinitions)aggregatedDefinitions);
        }
        this.compositeBuilder = ReallySmallRuntimeBuilder.createCompositeBuilder(this.monitor, this.assemblyFactory, scaBindingFactory, endpointFactory, intentAttachPointTypeFactory, documentBuilderFactory, transformerFactory, mapper, (SCADefinitions)aggregatedDefinitions);
        this.compositeBuilder.build(composite);
    }

    public ContributionService getContributionService() {
        return this.contributionService;
    }

    public CompositeActivator getCompositeActivator() {
        return this.compositeActivator;
    }

    public CompositeBuilder getCompositeBuilder() {
        return this.compositeBuilder;
    }

    public AssemblyFactory getAssemblyFactory() {
        return this.assemblyFactory;
    }

    private void loadSCADefinitions() throws ActivationException {
        try {
            URLArtifactProcessorExtensionPoint documentProcessors = (URLArtifactProcessorExtensionPoint)this.registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
            URLArtifactProcessor definitionsProcessor = (URLArtifactProcessor)documentProcessors.getProcessor(SCADefinitions.class);
            SCADefinitionsProviderExtensionPoint scaDefnProviders = (SCADefinitionsProviderExtensionPoint)this.registry.getExtensionPoint(SCADefinitionsProviderExtensionPoint.class);
            SCADefinitionsImpl systemSCADefinitions = new SCADefinitionsImpl();
            SCADefinitions aSCADefn = null;
            for (SCADefinitionsProvider aProvider : scaDefnProviders.getSCADefinitionsProviders()) {
                aSCADefn = aProvider.getSCADefinition();
                SCADefinitionsUtil.aggregateSCADefinitions((SCADefinitions)aSCADefn, (SCADefinitions)systemSCADefinitions);
            }
            this.policyDefinitions.add((SCADefinitions)systemSCADefinitions);
            for (Intent intent : systemSCADefinitions.getPolicyIntents()) {
                this.policyDefinitionsResolver.addModel((Object)intent);
            }
            for (PolicySet policySet : systemSCADefinitions.getPolicySets()) {
                this.policyDefinitionsResolver.addModel((Object)policySet);
            }
            for (IntentAttachPointType attachPoinType : systemSCADefinitions.getBindingTypes()) {
                this.policyDefinitionsResolver.addModel((Object)attachPoinType);
            }
            for (IntentAttachPointType attachPoinType : systemSCADefinitions.getImplementationTypes()) {
                this.policyDefinitionsResolver.addModel((Object)attachPoinType);
            }
            definitionsProcessor.resolve((Object)systemSCADefinitions, this.policyDefinitionsResolver);
        }
        catch (Exception e) {
            throw new ActivationException((Throwable)e);
        }
    }

    private List<ModuleActivator> loadModules(ExtensionPointRegistry registry) throws ActivationException {
        this.modules = new ArrayList<ModuleActivator>();
        try {
            Set moduleActivators = ServiceDiscovery.getInstance().getServiceDeclarations(ModuleActivator.class);
            HashSet<String> moduleClasses = new HashSet<String>();
            for (ServiceDeclaration moduleDeclarator : moduleActivators) {
                if (moduleClasses.contains(moduleDeclarator.getClassName())) continue;
                moduleClasses.add(moduleDeclarator.getClassName());
                Class moduleClass = moduleDeclarator.loadClass();
                ModuleActivator module = (ModuleActivator)moduleClass.newInstance();
                this.modules.add(module);
            }
        }
        catch (IOException e) {
            throw new ActivationException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ActivationException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ActivationException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ActivationException((Throwable)e);
        }
        return this.modules;
    }

    private void startModules(ExtensionPointRegistry registry, List<ModuleActivator> modules) throws ActivationException {
        boolean debug = logger.isLoggable(Level.FINE);
        for (ModuleActivator module : modules) {
            long start = 0L;
            if (debug) {
                logger.fine(module.getClass().getName() + " is starting.");
                start = System.currentTimeMillis();
            }
            try {
                module.start(registry);
                if (!debug) continue;
                long end = System.currentTimeMillis();
                logger.fine(module.getClass().getName() + " is started in " + (end - start) + " ms.");
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Exception starting module " + module.getClass().getName() + " :" + e.getMessage());
                logger.log(Level.FINE, "Exception starting module " + module.getClass().getName(), e);
            }
        }
    }

    private void stopModules(ExtensionPointRegistry registry, List<ModuleActivator> modules) {
        boolean debug = logger.isLoggable(Level.FINE);
        for (ModuleActivator module : modules) {
            long start = 0L;
            if (debug) {
                logger.fine(module.getClass().getName() + " is stopping.");
                start = System.currentTimeMillis();
            }
            module.stop(registry);
            if (!debug) continue;
            long end = System.currentTimeMillis();
            logger.fine(module.getClass().getName() + " is stopped in " + (end - start) + " ms.");
        }
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.registry;
    }
}

