/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.embedded.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.service.ContributionService;
import org.apache.tuscany.sca.contribution.service.util.FileHelper;
import org.apache.tuscany.sca.core.assembly.ActivationException;
import org.apache.tuscany.sca.host.embedded.SCADomain;
import org.apache.tuscany.sca.host.embedded.impl.EmbeddedSCADomain;
import org.apache.tuscany.sca.host.embedded.management.ComponentManager;
import org.osoa.sca.CallableReference;
import org.osoa.sca.ServiceReference;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotUpdatableSCADomain
extends SCADomain {
    private static final Logger logger = Logger.getLogger(HotUpdatableSCADomain.class.getName());
    protected String domainURI;
    protected File contributionRepository;
    protected EmbeddedSCADomain scaDomain;
    protected boolean hotUpdateActive;
    protected Thread hotUpdateThread;
    protected int hotUpdateInterval;
    protected HashMap<URL, Long> existingContributions;
    protected ClassLoader originalCCL;
    protected static final String REPOSITORY_FOLDER = "sca-contributions";

    public HotUpdatableSCADomain(String domainURI, File contributionRepository, int hotupdateInterval) {
        this.domainURI = domainURI;
        this.contributionRepository = contributionRepository;
        this.hotUpdateInterval = hotupdateInterval;
        this.originalCCL = Thread.currentThread().getContextClassLoader();
        this.start();
    }

    protected void start() {
        try {
            this.initEmbeddedSCADomain();
            this.activateHotUpdate();
            for (URL url : this.existingContributions.keySet()) {
                File f = new File(url.toURI());
                logger.info("added contribution: " + f.getName());
            }
        }
        catch (ActivationException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.hotUpdateActive = false;
            this.scaDomain.stop();
        }
        catch (ActivationException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        Thread.currentThread().setContextClassLoader(this.originalCCL);
        super.close();
    }

    protected SCADomain initEmbeddedSCADomain() throws ActivationException {
        URL[] contributionJars = this.getContributionJarURLs(this.contributionRepository);
        this.existingContributions = this.getLastModified(contributionJars);
        if (this.hotUpdateInterval > 0) {
            contributionJars = this.copyContributionsToTemp(contributionJars);
        }
        URLClassLoader cl = new URLClassLoader(contributionJars, this.originalCCL);
        Thread.currentThread().setContextClassLoader(cl);
        this.scaDomain = new EmbeddedSCADomain(cl, this.domainURI);
        this.scaDomain.start();
        this.initContributions(this.scaDomain, cl, contributionJars);
        return this.scaDomain;
    }

    protected URL[] getContributionJarURLs(File repositoryDir) {
        String[] jars = repositoryDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        ArrayList<URL> contributionJars = new ArrayList<URL>();
        if (jars != null) {
            for (String jar : jars) {
                try {
                    contributionJars.add(new File(repositoryDir, jar).toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return contributionJars.toArray(new URL[contributionJars.size()]);
    }

    protected void initContributions(EmbeddedSCADomain scaDomain, ClassLoader cl, URL[] contributionJars) {
        Contribution contribution = null;
        ContributionService contributionService = scaDomain.getContributionService();
        for (URL jar : contributionJars) {
            InputStream is = null;
            try {
                is = jar.openStream();
                contribution = contributionService.contribute(jar.toString(), jar, is);
            }
            catch (Exception e) {
                System.err.println("exception adding contribution: " + jar);
                e.printStackTrace();
            }
            if (is == null) continue;
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (contribution != null) {
            try {
                for (Composite composite : contribution.getDeployables()) {
                    scaDomain.getDomainComposite().getIncludes().add(composite);
                    scaDomain.getCompositeBuilder().build(composite);
                    scaDomain.getCompositeActivator().activate(composite);
                }
                for (Composite composite : contribution.getDeployables()) {
                    scaDomain.getCompositeActivator().start(composite);
                }
            }
            catch (ActivationException e) {
                throw new RuntimeException(e);
            }
            catch (CompositeBuilderException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected URL[] copyContributionsToTemp(URL[] contributionJars) {
        try {
            URL[] newURLs = new URL[contributionJars.length];
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            for (int i = 0; i < contributionJars.length; ++i) {
                File fin = new File(contributionJars[i].toURI());
                File fout = File.createTempFile("tuscany", fin.getName(), tempDir);
                fout.deleteOnExit();
                FileHelper.copyFile((File)fin, (File)fout);
                fout.setLastModified(System.currentTimeMillis());
                newURLs[i] = fout.toURL();
            }
            return newURLs;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected HashMap<URL, Long> getLastModified(URL[] contrabutions) {
        try {
            HashMap<URL, Long> contributionLastUpdates = new HashMap<URL, Long>();
            for (URL url : contrabutions) {
                File f = new File(url.toURI());
                contributionLastUpdates.put(url, new Long(f.lastModified()));
            }
            return contributionLastUpdates;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected void activateHotUpdate() {
        if (this.hotUpdateInterval == 0) {
            return;
        }
        Runnable runable = new Runnable(){

            public void run() {
                logger.info("Tuscany contribution hotupdate running");
                while (HotUpdatableSCADomain.this.hotUpdateActive) {
                    try {
                        Thread.sleep(HotUpdatableSCADomain.this.hotUpdateInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!HotUpdatableSCADomain.this.hotUpdateActive) continue;
                    HotUpdatableSCADomain.this.checkForUpdates();
                }
                logger.info("Tuscany contribution hotupdate stopped");
            }
        };
        this.hotUpdateThread = new Thread(runable, "TuscanyHotUpdate");
        this.hotUpdateActive = true;
        this.hotUpdateThread.start();
    }

    protected void checkForUpdates() {
        URL[] currentContributions = this.getContributionJarURLs(this.contributionRepository);
        if (this.areContributionsAltered(currentContributions)) {
            try {
                this.scaDomain.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.initEmbeddedSCADomain();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean areContributionsAltered(URL[] currentContrabutions) {
        try {
            List addedContributions = this.getAddedContributions(currentContrabutions);
            List removedContributions = this.getRemovedContributions(currentContrabutions);
            List<URL> updatedContributions = this.getUpdatedContributions(currentContrabutions);
            return addedContributions.size() > 0 || removedContributions.size() > 0 || updatedContributions.size() > 0;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<URL> getUpdatedContributions(URL[] currentContrabutions) throws URISyntaxException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL url : currentContrabutions) {
            File curentFile;
            if (!this.existingContributions.containsKey(url) || (curentFile = new File(url.toURI())).lastModified() == this.existingContributions.get(url).longValue()) continue;
            urls.add(url);
            logger.info("updated contribution: " + curentFile.getName());
        }
        return urls;
    }

    protected List getRemovedContributions(URL[] currentContrabutions) throws URISyntaxException {
        List<URL> currentUrls = Arrays.asList(currentContrabutions);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL url : this.existingContributions.keySet()) {
            if (currentUrls.contains(url)) continue;
            urls.add(url);
        }
        for (URL url : urls) {
            logger.info("removed contributions: " + new File(url.toURI()).getName());
        }
        return urls;
    }

    protected List getAddedContributions(URL[] currentContrabutions) throws URISyntaxException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL url : currentContrabutions) {
            if (this.existingContributions.containsKey(url)) continue;
            urls.add(url);
            logger.info("added contribution: " + new File(url.toURI()).getName());
        }
        return urls;
    }

    @Override
    public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public <B> B getService(Class<B> businessInterface, String serviceName) {
        return this.scaDomain.getService(businessInterface, serviceName);
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String referenceName) {
        return this.scaDomain.getServiceReference(businessInterface, referenceName);
    }

    @Override
    public String getURI() {
        return this.domainURI;
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.scaDomain.getComponentManager();
    }
}

