/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.extensibility.ClassLoaderServiceDiscoverer;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscoverer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDiscovery {
    private static final Logger logger = Logger.getLogger(ServiceDiscovery.class.getName());
    private static final ServiceDiscovery INSTANCE = new ServiceDiscovery();
    private ServiceDiscoverer discoverer;
    private Set<ClassLoader> registeredClassLoaders = new HashSet<ClassLoader>();

    public static ServiceDiscovery getInstance() {
        return INSTANCE;
    }

    public ServiceDiscoverer getServiceDiscoverer() {
        if (this.discoverer == null) {
            this.discoverer = new ClassLoaderServiceDiscoverer();
        }
        return this.discoverer;
    }

    public void setServiceDiscoverer(ServiceDiscoverer sd) {
        if (this.discoverer != null) {
            throw new IllegalStateException("The ServiceDiscoverer cannot be reset");
        }
        this.discoverer = sd;
    }

    @Deprecated
    public synchronized void registerClassLoader(ClassLoader classLoader) {
        this.registeredClassLoaders.add(classLoader);
    }

    @Deprecated
    public synchronized void unregisterClassLoader(ClassLoader classLoader) {
        this.registeredClassLoaders.remove(classLoader);
    }

    public Set<ServiceDeclaration> getServiceDeclarations(String name) throws IOException {
        Set<ServiceDeclaration> services = this.getServiceDiscoverer().discover(name, false);
        return services;
    }

    public Set<ServiceDeclaration> getServiceDeclarations(Class<?> serviceInterface) throws IOException {
        return this.getServiceDeclarations(serviceInterface.getName());
    }

    public Class<?> loadFirstServiceClass(final Class<?> serviceInterface) throws IOException, ClassNotFoundException {
        Set<ServiceDeclaration> services;
        String className = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(serviceInterface.getName());
            }
        });
        if (className != null) {
            try {
                return Class.forName(className, false, serviceInterface.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                try {
                    return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
        if ((services = this.getServiceDiscoverer().discover(serviceInterface.getName(), true)).isEmpty()) {
            return null;
        }
        return services.iterator().next().loadClass();
    }

    public Object newFactoryClassInstance(Class<?> serviceInterface) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method newInstanceMethod = serviceInterface.getMethod("newInstance", new Class[0]);
        Object factory = newInstanceMethod.invoke(null, new Object[0]);
        return factory;
    }
}

