/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUtilityExtensionPoint
implements UtilityExtensionPoint {
    private Map<Class<?>, Object> utilities = new HashMap();
    private ExtensionPointRegistry extensionPoints;

    public DefaultUtilityExtensionPoint(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
    }

    @Override
    public void addUtility(Object utility) {
        if (utility == null) {
            throw new IllegalArgumentException("Cannot register null as a Service");
        }
        Set<Class<?>> interfaces = DefaultUtilityExtensionPoint.getAllInterfaces(utility.getClass());
        for (Class<?> i : interfaces) {
            this.utilities.put(i, utility);
        }
    }

    private Constructor<?> getConstructor(Constructor<?>[] constructors, Class<?>[] paramTypes) {
        for (Constructor<?> c : constructors) {
            Class<?>[] types = c.getParameterTypes();
            if (c.getParameterTypes().length != paramTypes.length) continue;
            boolean found = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == paramTypes[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return c;
        }
        return null;
    }

    @Override
    public <T> T getUtility(Class<T> utilityType) {
        if (utilityType == null) {
            throw new IllegalArgumentException("Cannot lookup Service of type null");
        }
        Object utility = this.utilities.get(utilityType);
        if (utility == null) {
            try {
                Class<?> utilityClass = ServiceDiscovery.getInstance().loadFirstServiceClass(utilityType);
                if (utilityClass != null) {
                    Constructor<?>[] constructors = utilityClass.getConstructors();
                    Constructor<?> constructor = this.getConstructor(constructors, new Class[]{ExtensionPointRegistry.class});
                    if (constructor != null) {
                        utility = constructor.newInstance(this.extensionPoints);
                    } else {
                        constructor = this.getConstructor(constructors, new Class[0]);
                        if (constructor != null) {
                            utility = constructor.newInstance(new Object[0]);
                        } else {
                            throw new IllegalArgumentException("No valid constructor is found for " + utilityClass);
                        }
                    }
                    this.addUtility(utility);
                }
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return utilityType.cast(utility);
    }

    @Override
    public void removeUtility(Object utility) {
        if (utility == null) {
            throw new IllegalArgumentException("Cannot remove null as a Service");
        }
        Set<Class<?>> interfaces = DefaultUtilityExtensionPoint.getAllInterfaces(utility.getClass());
        for (Class<?> i : interfaces) {
            this.utilities.remove(i);
        }
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet implemented = new HashSet();
        DefaultUtilityExtensionPoint.getAllInterfaces(clazz, implemented);
        return implemented;
    }

    private static void getAllInterfaces(Class<?> clazz, Set<Class<?>> implemented) {
        Class<?>[] interfaces;
        for (Class<?> interfaze : interfaces = clazz.getInterfaces()) {
            if (!Modifier.isPublic(interfaze.getModifiers())) continue;
            implemented.add(interfaze);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            DefaultUtilityExtensionPoint.getAllInterfaces(superClass, implemented);
        }
    }
}

