/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExtensionPointRegistry
implements ExtensionPointRegistry {
    private Map<Class<?>, Object> extensionPoints = new HashMap();

    @Override
    public void addExtensionPoint(Object extensionPoint) {
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Cannot register null as an ExtensionPoint");
        }
        Set<Class<?>> interfaces = DefaultExtensionPointRegistry.getAllInterfaces(extensionPoint.getClass());
        for (Class<?> i : interfaces) {
            this.extensionPoints.put(i, extensionPoint);
        }
    }

    private Constructor<?> getConstructor(Constructor<?>[] constructors, Class<?>[] paramTypes) {
        for (Constructor<?> c : constructors) {
            Class<?>[] types = c.getParameterTypes();
            if (c.getParameterTypes().length != paramTypes.length) continue;
            boolean found = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == paramTypes[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return c;
        }
        return null;
    }

    @Override
    public <T> T getExtensionPoint(Class<T> extensionPointType) {
        if (extensionPointType == null) {
            throw new IllegalArgumentException("Cannot lookup ExtensionPoint of type null");
        }
        Object extensionPoint = this.extensionPoints.get(extensionPointType);
        if (extensionPoint == null) {
            try {
                Class<?> extensionPointClass = ServiceDiscovery.getInstance().loadFirstServiceClass(extensionPointType);
                if (extensionPointClass != null) {
                    Constructor<?>[] constructors = extensionPointClass.getConstructors();
                    Constructor<?> constructor = this.getConstructor(constructors, new Class[]{ExtensionPointRegistry.class});
                    if (constructor != null) {
                        extensionPoint = constructor.newInstance(this);
                    } else {
                        constructor = this.getConstructor(constructors, new Class[0]);
                        if (constructor != null) {
                            extensionPoint = constructor.newInstance(new Object[0]);
                        } else {
                            throw new IllegalArgumentException("No valid constructor is found for " + extensionPointClass);
                        }
                    }
                    this.addExtensionPoint(extensionPoint);
                }
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return extensionPointType.cast(extensionPoint);
    }

    @Override
    public void removeExtensionPoint(Object extensionPoint) {
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Cannot remove null as an ExtensionPoint");
        }
        Set<Class<?>> interfaces = DefaultExtensionPointRegistry.getAllInterfaces(extensionPoint.getClass());
        for (Class<?> i : interfaces) {
            this.extensionPoints.remove(i);
        }
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet implemented = new HashSet();
        DefaultExtensionPointRegistry.getAllInterfaces(clazz, implemented);
        return implemented;
    }

    private static void getAllInterfaces(Class<?> clazz, Set<Class<?>> implemented) {
        Class<?>[] interfaces;
        for (Class<?> interfaze : interfaces = clazz.getInterfaces()) {
            if (!Modifier.isPublic(interfaze.getModifiers())) continue;
            implemented.add(interfaze);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            DefaultExtensionPointRegistry.getAllInterfaces(superClass, implemented);
        }
    }
}

