/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.databinding.xml.BeanXMLStreamReaderImpl;
import org.apache.tuscany.sca.databinding.xml.DelegatingNamespaceContext;
import org.apache.tuscany.sca.databinding.xml.NameValueArrayStreamReader;
import org.apache.tuscany.sca.databinding.xml.NameValuePairStreamReader;
import org.apache.tuscany.sca.databinding.xml.NamedProperty;
import org.apache.tuscany.sca.databinding.xml.NilElementStreamReader;
import org.apache.tuscany.sca.databinding.xml.WrappingXMLStreamReader;
import org.apache.tuscany.sca.databinding.xml.XMLFragmentStreamReader;
import org.apache.tuscany.sca.databinding.xml.XMLStreamable;

public class XMLFragmentStreamReaderImpl
implements XMLFragmentStreamReader {
    private static final int DELEGATED_STATE = 2;
    private static final int END_ELEMENT_STATE = 1;
    private static final int START_ELEMENT_STATE = 0;
    private static final int TEXT_STATE = 3;
    protected NamedProperty[] attributes;
    protected XMLFragmentStreamReader childReader;
    protected int index;
    protected Map<String, String> declaredNamespaceMap = new HashMap<String, String>();
    protected QName elementQName;
    protected DelegatingNamespaceContext namespaceContext = new DelegatingNamespaceContext();
    protected NamedProperty[] elements;
    protected int state = 0;

    public XMLFragmentStreamReaderImpl(QName elementQName, NamedProperty[] elements, NamedProperty[] attributes) {
        this.elements = elements == null ? new NamedProperty[]{} : elements;
        this.elementQName = elementQName;
        this.attributes = attributes == null ? new NamedProperty[]{} : attributes;
    }

    protected XMLFragmentStreamReaderImpl(QName elementQName) {
        this.elementQName = elementQName;
    }

    public void setParentNamespaceContext(NamespaceContext nsContext) {
        this.namespaceContext.setParentNsContext(nsContext);
    }

    protected NamedProperty[] getElements() {
        return this.elements;
    }

    protected NamedProperty[] getAttributes() {
        return this.attributes;
    }

    protected QName[] getNamespaces() {
        return new QName[0];
    }

    protected void addToNsMap(String prefix, String uri) {
        if (!uri.equals(this.namespaceContext.getNamespaceURI(prefix))) {
            this.namespaceContext.pushNamespace(prefix, uri);
            this.declaredNamespaceMap.put(prefix, uri);
        }
    }

    public void close() throws XMLStreamException {
    }

    public int getAttributeCount() {
        return this.state == 2 ? this.childReader.getAttributeCount() : (this.state == 0 ? this.getAttributes().length : 0);
    }

    public String getAttributeLocalName(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeLocalName(i);
        }
        if (this.state == 0) {
            QName name = this.getAttributeName(i);
            if (name == null) {
                return null;
            }
            return name.getLocalPart();
        }
        throw new IllegalStateException();
    }

    public QName getAttributeName(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeName(i);
        }
        if (this.state == 0) {
            if (i >= this.getAttributes().length || i < 0) {
                return null;
            }
            QName attribPointer = this.getAttributes()[i].getKey();
            if (attribPointer == null) {
                throw new UnsupportedOperationException();
            }
            if (attribPointer instanceof QName) {
                return attribPointer;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public String getAttributeNamespace(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeNamespace(i);
        }
        if (this.state == 0) {
            QName name = this.getAttributeName(i);
            if (name == null) {
                return null;
            }
            return name.getNamespaceURI();
        }
        throw new IllegalStateException();
    }

    public String getAttributePrefix(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributePrefix(i);
        }
        if (this.state == 0) {
            QName name = this.getAttributeName(i);
            if (name == null) {
                return null;
            }
            return name.getPrefix();
        }
        throw new IllegalStateException();
    }

    public String getAttributeType(int i) {
        return null;
    }

    public String getAttributeValue(int i) {
        if (this.state == 2) {
            return this.childReader.getAttributeValue(i);
        }
        if (this.state == 0) {
            if (i >= this.getAttributes().length || i < 0) {
                return null;
            }
            QName attribPointer = this.getAttributes()[i].getKey();
            Object omAttribObj = this.getAttributes()[i].getValue();
            if (attribPointer == null) {
                throw new UnsupportedOperationException();
            }
            if (attribPointer instanceof QName) {
                return (String)omAttribObj;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public String getAttributeValue(String nsUri, String localName) {
        int attribCount = this.getAttributeCount();
        String returnValue = null;
        for (int i = 0; i < attribCount; ++i) {
            QName attribQualifiedName = this.getAttributeName(i);
            if (nsUri == null) {
                if (!localName.equals(attribQualifiedName.getLocalPart())) continue;
                returnValue = this.getAttributeValue(i);
                break;
            }
            if (!localName.equals(attribQualifiedName.getLocalPart()) || !nsUri.equals(attribQualifiedName.getNamespaceURI())) continue;
            returnValue = this.getAttributeValue(i);
            break;
        }
        return returnValue;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getElementText() throws XMLStreamException {
        if (this.state == 2) {
            return this.childReader.getElementText();
        }
        return null;
    }

    public String getEncoding() {
        if (this.state == 2) {
            return this.childReader.getEncoding();
        }
        return null;
    }

    public int getEventType() {
        if (this.state == 0) {
            return 1;
        }
        if (this.state == 1) {
            return 2;
        }
        if (this.state == 3) {
            return 4;
        }
        return this.childReader.getEventType();
    }

    public String getLocalName() {
        if (this.state == 2) {
            return this.childReader.getLocalName();
        }
        if (this.state != 3) {
            return this.elementQName.getLocalPart();
        }
        throw new IllegalStateException();
    }

    public Location getLocation() {
        return new Location(){

            public int getCharacterOffset() {
                return 0;
            }

            public int getColumnNumber() {
                return 0;
            }

            public int getLineNumber() {
                return 0;
            }

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return null;
            }
        };
    }

    public QName getName() {
        if (this.state == 2) {
            return this.childReader.getName();
        }
        if (this.state != 3) {
            return this.elementQName;
        }
        throw new IllegalStateException();
    }

    public NamespaceContext getNamespaceContext() {
        if (this.state == 2) {
            return this.childReader.getNamespaceContext();
        }
        return this.namespaceContext;
    }

    public int getNamespaceCount() {
        if (this.state == 2) {
            return this.childReader.getNamespaceCount();
        }
        return this.declaredNamespaceMap.size();
    }

    public String getNamespacePrefix(int i) {
        if (this.state == 2) {
            return this.childReader.getNamespacePrefix(i);
        }
        if (this.state != 3) {
            String[] prefixes = this.makePrefixArray();
            if (i >= prefixes.length || i < 0) {
                return null;
            }
            return prefixes[i];
        }
        throw new IllegalStateException();
    }

    public String getNamespaceURI() {
        if (this.state == 2) {
            return this.childReader.getNamespaceURI();
        }
        if (this.state == 3) {
            return null;
        }
        return this.elementQName.getNamespaceURI();
    }

    public String getNamespaceURI(int i) {
        if (this.state == 2) {
            return this.childReader.getNamespaceURI(i);
        }
        if (this.state != 3) {
            String namespacePrefix = this.getNamespacePrefix(i);
            return namespacePrefix == null ? null : this.declaredNamespaceMap.get(namespacePrefix);
        }
        throw new IllegalStateException();
    }

    public String getNamespaceURI(String prefix) {
        return this.namespaceContext.getNamespaceURI(prefix);
    }

    public String getPIData() {
        throw new UnsupportedOperationException("Yet to be implemented !!");
    }

    public String getPITarget() {
        throw new UnsupportedOperationException("Yet to be implemented !!");
    }

    public String getPrefix() {
        if (this.state == 2) {
            return this.childReader.getPrefix();
        }
        if (this.state == 3) {
            return null;
        }
        String prefix = this.elementQName.getPrefix();
        return "".equals(prefix) ? null : prefix;
    }

    public Object getProperty(String key) throws IllegalArgumentException {
        if (this.state == 0 || this.state == 1) {
            return null;
        }
        if (this.state == 3) {
            return null;
        }
        if (this.state == 2) {
            return this.childReader.getProperty(key);
        }
        return null;
    }

    public String getText() {
        if (this.state == 2) {
            return this.childReader.getText();
        }
        if (this.state == 3) {
            return (String)this.getElements()[this.index - 1].getValue();
        }
        throw new IllegalStateException();
    }

    public char[] getTextCharacters() {
        if (this.state == 2) {
            return this.childReader.getTextCharacters();
        }
        if (this.state == 3) {
            return this.getElements()[this.index - 1].getValue() == null ? new char[]{} : ((String)this.getElements()[this.index - 1].getValue()).toCharArray();
        }
        throw new IllegalStateException();
    }

    private int copy(int sourceStart, char[] target, int targetStart, int length) {
        char[] source = this.getTextCharacters();
        if (sourceStart > source.length) {
            throw new IndexOutOfBoundsException("source start > source length");
        }
        int sourceLen = source.length - sourceStart;
        if (length > sourceLen) {
            length = sourceLen;
        }
        System.arraycopy(source, sourceStart, target, targetStart, length);
        return sourceLen;
    }

    public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
        if (this.state == 2) {
            return this.childReader.getTextCharacters(i, chars, i1, i2);
        }
        if (this.state == 3) {
            return this.copy(i, chars, i1, i2);
        }
        throw new IllegalStateException();
    }

    public int getTextLength() {
        if (this.state == 2) {
            return this.childReader.getTextLength();
        }
        if (this.state == 3) {
            return this.getTextCharacters().length;
        }
        throw new IllegalStateException();
    }

    public int getTextStart() {
        if (this.state == 2) {
            return this.childReader.getTextStart();
        }
        if (this.state == 3) {
            return 0;
        }
        throw new IllegalStateException();
    }

    public String getVersion() {
        return null;
    }

    public boolean hasName() {
        if (this.state == 2) {
            return this.childReader.hasName();
        }
        return this.state != 3;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.state == 2) {
            if (this.childReader.isDone()) {
                return true;
            }
            return this.childReader.hasNext();
        }
        return this.state == 0 || this.state == 3;
    }

    public boolean hasText() {
        if (this.state == 2) {
            return this.childReader.hasText();
        }
        return this.state == 3;
    }

    public void init() {
        this.populateNamespaceContext();
    }

    public boolean isAttributeSpecified(int i) {
        return false;
    }

    public boolean isCharacters() {
        if (this.state == 0 || this.state == 1) {
            return false;
        }
        return this.childReader.isCharacters();
    }

    public boolean isDone() {
        return this.state == 1;
    }

    public boolean isEndElement() {
        if (this.state == 0) {
            return false;
        }
        if (this.state == 1) {
            return true;
        }
        return this.childReader.isEndElement();
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isStartElement() {
        if (this.state == 0) {
            return true;
        }
        if (this.state == 1) {
            return false;
        }
        return this.childReader.isStartElement();
    }

    public boolean isWhiteSpace() {
        if (this.state == 0 || this.state == 1) {
            return false;
        }
        return this.childReader.isWhiteSpace();
    }

    private String[] makePrefixArray() {
        Object[] prefixes = this.declaredNamespaceMap.keySet().toArray(new String[this.declaredNamespaceMap.size()]);
        Arrays.sort(prefixes);
        return prefixes;
    }

    public int next() throws XMLStreamException {
        int returnEvent = -1;
        switch (this.state) {
            case 0: {
                if (this.getElements() == null || this.getElements().length == 0) {
                    this.state = 1;
                    returnEvent = 2;
                    break;
                }
                returnEvent = this.processProperties();
                break;
            }
            case 1: {
                throw new XMLStreamException("Trying to go beyond the end of the pullparser");
            }
            case 2: {
                if (this.childReader.isDone()) {
                    if (this.index > this.getElements().length - 1) {
                        this.state = 1;
                        returnEvent = 2;
                        break;
                    }
                    returnEvent = this.processProperties();
                    break;
                }
                returnEvent = this.childReader.next();
                break;
            }
            case 3: {
                if (this.index > this.getElements().length - 1) {
                    this.state = 1;
                    returnEvent = 2;
                    break;
                }
                returnEvent = this.processProperties();
            }
        }
        return returnEvent;
    }

    public int nextTag() throws XMLStreamException {
        return 0;
    }

    private void populateNamespaceContext() {
        this.addToNsMap(this.elementQName.getPrefix(), this.elementQName.getNamespaceURI());
        for (QName n : this.getNamespaces()) {
            this.addToNsMap(n.getPrefix(), n.getNamespaceURI());
        }
        for (int i = 0; i < this.getAttributes().length; ++i) {
            QName attrQName = this.getAttributes()[i].getKey();
            if ("".equals(attrQName.getNamespaceURI())) continue;
            this.addToNsMap(attrQName.getPrefix(), attrQName.getNamespaceURI());
        }
    }

    private int processProperties() throws XMLStreamException {
        QName propertyQName = this.getElements()[this.index].getKey();
        boolean textFound = false;
        if (propertyQName == null) {
            throw new XMLStreamException("property key cannot be null!");
        }
        if ("Element Text".equals(propertyQName.getLocalPart())) {
            textFound = true;
        }
        Object propertyValue = this.getElements()[this.index].getValue();
        if (textFound) {
            this.childReader = null;
            this.state = 3;
            ++this.index;
            return 4;
        }
        if (propertyValue == null) {
            this.childReader = new NilElementStreamReader(propertyQName);
            this.childReader.setParentNamespaceContext(this.namespaceContext);
            this.childReader.init();
        } else if (propertyValue instanceof String) {
            this.childReader = new NameValuePairStreamReader(propertyQName, (String)propertyValue);
            this.childReader.setParentNamespaceContext(this.namespaceContext);
            this.childReader.init();
        } else if (propertyValue instanceof String[]) {
            if (((String[])propertyValue).length == 0) {
                ++this.index;
                return this.processProperties();
            }
            this.childReader = new NameValueArrayStreamReader(propertyQName, (String[])propertyValue);
            this.childReader.setParentNamespaceContext(this.namespaceContext);
            this.childReader.init();
        } else if (propertyValue instanceof XMLStreamable) {
            XMLStreamReader reader = ((XMLStreamable)propertyValue).getXMLStreamReader(propertyQName);
            if (reader instanceof XMLFragmentStreamReader) {
                this.childReader = (XMLFragmentStreamReader)reader;
                this.childReader.setParentNamespaceContext(this.namespaceContext);
                this.childReader.init();
            } else {
                this.childReader = new WrappingXMLStreamReader(reader);
            }
        } else if (propertyValue instanceof XMLStreamReader) {
            XMLStreamReader reader = (XMLStreamReader)propertyValue;
            if (reader instanceof XMLFragmentStreamReader) {
                this.childReader = (XMLFragmentStreamReader)reader;
                this.childReader.setParentNamespaceContext(this.namespaceContext);
                this.childReader.init();
            } else {
                this.childReader = new WrappingXMLStreamReader(reader);
            }
        } else {
            this.childReader = new WrappingXMLStreamReader(new BeanXMLStreamReaderImpl(propertyQName, propertyValue));
        }
        this.state = 2;
        ++this.index;
        return this.childReader.getEventType();
    }

    public void require(int i, String string, String string1) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public boolean standaloneSet() {
        return true;
    }
}

