/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.xml.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXmlNodeImpl
implements XmlNode {
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final QName XSI_NIL = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi");
    private static final Map<String, String> NS_MAP = new HashMap<String, String>();
    protected XmlNode.Type type;
    protected QName name;
    protected Object value;

    public SimpleXmlNodeImpl(QName name, Object value) {
        this(name, value, name != null ? XmlNode.Type.ELEMENT : XmlNode.Type.CHARACTERS);
    }

    public SimpleXmlNodeImpl(QName name, Object value, XmlNode.Type type) {
        this.type = type;
        this.name = name;
        this.value = value;
    }

    @Override
    public List<XmlNode> attributes() {
        if (this.type == XmlNode.Type.ELEMENT && this.value == null) {
            SimpleXmlNodeImpl attr = new SimpleXmlNodeImpl(XSI_NIL, "true");
            return Arrays.asList(attr);
        }
        return null;
    }

    @Override
    public Iterator<XmlNode> children() {
        if (this.type == XmlNode.Type.ELEMENT && this.value != null) {
            SimpleXmlNodeImpl node = new SimpleXmlNodeImpl(null, this.value);
            return Arrays.asList(node).iterator();
        }
        return null;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    public String getValue() {
        return this.value == null ? null : String.valueOf(this.value);
    }

    @Override
    public Map<String, String> namespaces() {
        if (this.type == XmlNode.Type.ELEMENT && this.value == null) {
            return NS_MAP;
        }
        return null;
    }

    @Override
    public XmlNode.Type getType() {
        return this.type;
    }

    public void setType(XmlNode.Type type) {
        this.type = type;
    }

    static {
        NS_MAP.put(XSI_PREFIX, XSI_NS);
    }
}

