/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.impl.DOMHelper;
import org.apache.tuscany.sca.databinding.xml.DOMDataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMWrapperHandler
implements WrapperHandler<Node> {
    @Override
    public Node create(Operation operation, boolean input) {
        try {
            WrapperInfo inputWrapperInfo = operation.getInputWrapper();
            WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
            ElementInfo element = input ? inputWrapperInfo.getWrapperElement() : outputWrapperInfo.getWrapperElement();
            Document document = DOMHelper.newDocument();
            QName name = element.getQName();
            return DOMHelper.createElement(document, name);
        }
        catch (ParserConfigurationException e) {
            throw new TransformationException(e);
        }
    }

    @Override
    public void setChildren(Node wrapper, Object[] childObjects, Operation operation, boolean input) {
        List childElements = input ? operation.getInputWrapper().getChildElements() : operation.getOutputWrapper().getChildElements();
        for (int i = 0; i < childElements.size(); ++i) {
            this.setChild(wrapper, i, (ElementInfo)childElements.get(i), childObjects[i]);
        }
    }

    public void setChild(Node wrapper, int i, ElementInfo childElement, Object value) {
        Node node = (Node)value;
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        }
        wrapper.appendChild(wrapper.getOwnerDocument().importNode(node, true));
    }

    @Override
    public List getChildren(Node wrapper, Operation operation, boolean input) {
        List childElements;
        assert (wrapper != null);
        List list = childElements = input ? operation.getInputWrapper().getChildElements() : operation.getOutputWrapper().getChildElements();
        if (wrapper.getNodeType() == 9) {
            wrapper = ((Document)wrapper).getDocumentElement();
        }
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodes = wrapper.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            if (node.getNodeType() != 1) continue;
            elements.add(node);
        }
        return elements;
    }

    @Override
    public DataType getWrapperType(Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        ElementInfo element = input ? inputWrapperInfo.getWrapperElement() : outputWrapperInfo.getWrapperElement();
        DataTypeImpl wrapperType = new DataTypeImpl(DOMDataBinding.NAME, Node.class, (Object)new XMLType(element));
        return wrapperType;
    }

    @Override
    public boolean isInstance(Object wrapperObj, Operation operation, boolean input) {
        WrapperInfo inputWrapperInfo = operation.getInputWrapper();
        WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
        ElementInfo element = input ? inputWrapperInfo.getWrapperElement() : outputWrapperInfo.getWrapperElement();
        List childElements = input ? inputWrapperInfo.getChildElements() : outputWrapperInfo.getChildElements();
        Node wrapper = (Node)wrapperObj;
        if (wrapper.getNodeType() == 9) {
            wrapper = ((Document)wrapper).getDocumentElement();
        }
        QName elementName = new QName(wrapper.getNamespaceURI(), wrapper.getLocalName());
        if (!element.getQName().equals(elementName)) {
            return false;
        }
        HashSet<QName> names = new HashSet<QName>();
        for (ElementInfo e : childElements) {
            names.add(e.getQName());
        }
        NodeList nodes = wrapper.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            if (node.getNodeType() != 1 || names.contains(elementName = new QName(wrapper.getNamespaceURI(), wrapper.getLocalName()))) continue;
            return false;
        }
        return true;
    }
}

