/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleType2JavaTransformer<T>
extends BaseTransformer<T, Object>
implements PullTransformer<T, Object> {
    protected SimpleTypeMapper mapper;

    public SimpleType2JavaTransformer() {
        this.mapper = new SimpleTypeMapperImpl();
    }

    public SimpleType2JavaTransformer(SimpleTypeMapper mapper) {
        this.mapper = mapper != null ? mapper : new SimpleTypeMapperImpl();
    }

    @Override
    public Object transform(T source, TransformationContext context) {
        QName type;
        XMLType xmlType = (XMLType)context.getSourceDataType().getLogical();
        QName qName = type = xmlType != null ? xmlType.getTypeName() : null;
        if (type == null) {
            xmlType = (XMLType)context.getTargetDataType().getLogical();
            type = xmlType != null ? xmlType.getTypeName() : null;
        }
        Object result = this.mapper.toJavaObject(type, this.getText(source), context);
        this.close(source);
        return result;
    }

    @Override
    protected Class<Object> getTargetType() {
        return Object.class;
    }

    @Override
    public int getWeight() {
        return 10000;
    }

    protected abstract String getText(T var1);

    protected void close(T source) {
    }

    @Override
    public String getTargetDataBinding() {
        return "java:simpleType";
    }
}

