/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.DataPipe;
import org.apache.tuscany.sca.databinding.DataPipeTransformer;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.PushTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.Transformer;
import org.apache.tuscany.sca.databinding.TransformerExtensionPoint;
import org.apache.tuscany.sca.databinding.impl.TransformationContextImpl;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.FaultExceptionMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediatorImpl
implements Mediator {
    private static final String TARGET_OPERATION = "target.operation";
    private static final String SOURCE_OPERATION = "source.operation";
    private ExtensionPointRegistry registry;
    private DataBindingExtensionPoint dataBindings;
    private TransformerExtensionPoint transformers;
    private FaultExceptionMapper faultExceptionMapper;

    MediatorImpl(DataBindingExtensionPoint dataBindings, TransformerExtensionPoint transformers) {
        this.dataBindings = dataBindings;
        this.transformers = transformers;
    }

    public MediatorImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
        this.dataBindings = (DataBindingExtensionPoint)registry.getExtensionPoint(DataBindingExtensionPoint.class);
        this.transformers = (TransformerExtensionPoint)registry.getExtensionPoint(TransformerExtensionPoint.class);
        this.faultExceptionMapper = (FaultExceptionMapper)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(FaultExceptionMapper.class);
    }

    @Override
    public Object mediate(Object source, DataType sourceDataType, DataType targetDataType, Map<String, Object> metadata) {
        if ((sourceDataType == null || sourceDataType.getDataBinding() == null) && source != null) {
            Operation operation = (Operation)metadata.get(SOURCE_OPERATION);
            sourceDataType = this.dataBindings.introspectType(source, operation);
        }
        if (sourceDataType == null || targetDataType == null) {
            return source;
        }
        if (sourceDataType.equals(targetDataType)) {
            return source;
        }
        List<Transformer> path = this.getTransformerChain(sourceDataType, targetDataType);
        Object result = source;
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            Transformer transformer = path.get(i);
            TransformationContext context = this.createTransformationContext(sourceDataType, targetDataType, size, i, transformer, metadata);
            if (transformer instanceof PullTransformer) {
                result = ((PullTransformer)transformer).transform(result, context);
                continue;
            }
            if (!(transformer instanceof PushTransformer)) continue;
            DataPipeTransformer dataPipeFactory = i < size - 1 ? (DataPipeTransformer)path.get(++i) : null;
            DataPipe dataPipe = dataPipeFactory == null ? null : dataPipeFactory.newInstance();
            ((PushTransformer)transformer).transform(result, dataPipe.getSink(), context);
            result = dataPipe.getResult();
        }
        return result;
    }

    private TransformationContext createTransformationContext(DataType sourceDataType, DataType targetDataType, int size, int index, Transformer transformer, Map<String, Object> metadata) {
        DataType sourceType = index == 0 ? sourceDataType : new DataTypeImpl(transformer.getSourceDataBinding(), Object.class, sourceDataType.getLogical());
        DataType targetType = index == size - 1 ? targetDataType : new DataTypeImpl(transformer.getTargetDataBinding(), Object.class, targetDataType.getLogical());
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        HashMap<String, Object> copy = new HashMap<String, Object>();
        if (metadata != null) {
            copy.putAll(metadata);
        }
        copy.put(ExtensionPointRegistry.class.getName(), this.registry);
        TransformationContextImpl context = new TransformationContextImpl(sourceType, targetType, classLoader, copy);
        return context;
    }

    @Override
    public void mediate(Object source, Object target, DataType sourceDataType, DataType targetDataType, Map<String, Object> metadata) {
        if (source == null) {
            return;
        }
        if (sourceDataType == null || sourceDataType.getDataBinding() == null) {
            Operation operation = (Operation)metadata.get(SOURCE_OPERATION);
            sourceDataType = this.dataBindings.introspectType(source, operation);
        }
        if (sourceDataType == null) {
            return;
        }
        if (sourceDataType.equals(targetDataType)) {
            return;
        }
        List<Transformer> path = this.getTransformerChain(sourceDataType, targetDataType);
        Object result = source;
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            Transformer transformer = path.get(i);
            TransformationContext context = this.createTransformationContext(sourceDataType, targetDataType, size, i, transformer, metadata);
            if (transformer instanceof PullTransformer) {
                result = ((PullTransformer)transformer).transform(result, context);
                continue;
            }
            if (!(transformer instanceof PushTransformer)) continue;
            DataPipeTransformer dataPipeFactory = i < size - 1 ? (DataPipeTransformer)path.get(++i) : null;
            DataPipe dataPipe = dataPipeFactory == null ? null : dataPipeFactory.newInstance();
            Object sink = dataPipe != null ? dataPipe.getSink() : target;
            ((PushTransformer)transformer).transform(result, sink, context);
            result = dataPipe != null ? dataPipe.getResult() : null;
        }
    }

    private List<Transformer> getTransformerChain(DataType sourceDataType, DataType targetDataType) {
        String targetId;
        String sourceId = sourceDataType.getDataBinding();
        List<Transformer> path = this.transformers.getTransformerChain(sourceId, targetId = targetDataType.getDataBinding());
        if (path == null) {
            TransformationException ex = new TransformationException("No path found for the transformation: " + sourceId + "->" + targetId);
            ex.setSourceDataBinding(sourceId);
            ex.setTargetDataBinding(targetId);
            throw ex;
        }
        return path;
    }

    @Override
    public DataBindingExtensionPoint getDataBindings() {
        return this.dataBindings;
    }

    @Override
    public TransformerExtensionPoint getTransformers() {
        return this.transformers;
    }

    private DataType getFaultType(DataType exceptionType) {
        return exceptionType == null ? null : (DataType)exceptionType.getLogical();
    }

    private boolean matches(QName qn1, QName qn2) {
        String e2;
        if (qn1 == qn2) {
            return true;
        }
        if (qn1 == null || qn2 == null) {
            return false;
        }
        String ns1 = qn1.getNamespaceURI();
        String ns2 = qn2.getNamespaceURI();
        String e1 = qn1.getLocalPart();
        return e1.equals(e2 = qn2.getLocalPart()) && (ns1.equals(ns2) || ns1.equals(ns2 + "/") || ns2.equals(ns1 + "/"));
    }

    private Object transformException(Object source, DataType sourceExType, DataType targetExType, DataType sourceType, DataType targetType, Map<String, Object> metadata) {
        if (sourceType == targetType || sourceType != null && sourceType.equals(targetType)) {
            return source;
        }
        DataTypeImpl eSourceDataType = new DataTypeImpl("idl:fault", sourceExType.getPhysical(), (Object)sourceType);
        DataTypeImpl eTargetDataType = new DataTypeImpl("idl:fault", targetExType.getPhysical(), (Object)targetType);
        return this.mediate(source, (DataType)eSourceDataType, (DataType)eTargetDataType, metadata);
    }

    @Override
    public Object mediateFault(Object result, Operation sourceOperation, Operation targetOperation, Map<String, Object> metadata) {
        DataType targetFaultType;
        if (result instanceof InvocationTargetException) {
            result = ((InvocationTargetException)result).getCause();
        }
        DataType targetDataType = null;
        for (DataType exType : targetOperation.getFaultTypes()) {
            if (!exType.getPhysical().isInstance(result)) continue;
            if (result instanceof FaultException) {
                DataType faultType = (DataType)exType.getLogical();
                if (!((FaultException)result).isMatchingType(faultType.getLogical())) continue;
                targetDataType = exType;
                break;
            }
            targetDataType = exType;
            break;
        }
        if ((targetFaultType = this.getFaultType(targetDataType)) == null) {
            Throwable cause = (Throwable)result;
            throw new ServiceRuntimeException(cause);
        }
        DataType sourceDataType = null;
        DataType sourceFaultType = null;
        for (DataType exType : sourceOperation.getFaultTypes()) {
            DataType faultType = this.getFaultType(exType);
            if (faultType == null || !this.typesMatch(targetFaultType.getLogical(), faultType.getLogical())) continue;
            sourceDataType = exType;
            sourceFaultType = faultType;
            break;
        }
        if (sourceFaultType == null) {
            Throwable cause = (Throwable)result;
            throw new ServiceRuntimeException(cause);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (metadata != null) {
            context.putAll(metadata);
        }
        if (targetOperation != null) {
            context.put(SOURCE_OPERATION, targetOperation);
        }
        if (sourceOperation != null) {
            context.put(TARGET_OPERATION, sourceOperation);
        }
        Object newResult = this.transformException(result, targetDataType, sourceDataType, targetFaultType, sourceFaultType, context);
        return newResult;
    }

    private boolean typesMatch(Object first, Object second) {
        if (first.equals(second)) {
            return true;
        }
        if (first instanceof XMLType && second instanceof XMLType) {
            XMLType t1 = (XMLType)first;
            XMLType t2 = (XMLType)second;
            return this.matches(t1.getElementName(), t2.getElementName());
        }
        return false;
    }

    @Override
    public Object mediateOutput(Object output, Operation sourceOperation, Operation targetOperation, Map<String, Object> metadata) {
        DataTypeImpl targetType = new DataTypeImpl("idl:output", Object.class, (Object)targetOperation.getOutputType());
        DataTypeImpl sourceType = new DataTypeImpl("idl:output", Object.class, (Object)sourceOperation.getOutputType());
        if (sourceType == targetType || sourceType != null && sourceType.equals(targetType)) {
            return output;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (metadata != null) {
            context.putAll(metadata);
        }
        if (targetOperation != null) {
            context.put(SOURCE_OPERATION, targetOperation);
        }
        if (sourceOperation != null) {
            context.put(TARGET_OPERATION, sourceOperation);
        }
        return this.mediate(output, (DataType)targetType, (DataType)sourceType, context);
    }

    @Override
    public Object mediateInput(Object input, Operation sourceOperation, Operation targetOperation, Map<String, Object> metadata) {
        DataType targetType;
        DataType sourceType = sourceOperation.getInputType();
        if (sourceType == (targetType = targetOperation.getInputType()) || sourceType != null && sourceType.equals(targetType)) {
            return input;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (metadata != null) {
            context.putAll(metadata);
        }
        if (sourceOperation != null) {
            context.put(SOURCE_OPERATION, sourceOperation);
        }
        if (targetOperation != null) {
            context.put(TARGET_OPERATION, targetOperation);
        }
        return this.mediate(input, sourceType, targetType, context);
    }

    @Override
    public TransformationContext createTransformationContext() {
        return new TransformationContextImpl();
    }

    @Override
    public TransformationContext createTransformationContext(DataType sourceDataType, DataType targetDataType, Map<String, Object> metadata) {
        return new TransformationContextImpl(sourceDataType, targetDataType, metadata);
    }

    @Override
    public Object copy(Object data, DataType dataType) {
        return this.copy(data, dataType, null);
    }

    private Object copy(Object data, DataType dataType, Operation operation) {
        if (data == null) {
            return null;
        }
        Class<?> clazz = data.getClass();
        if (String.class == clazz || clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || URI.class == clazz || UUID.class == clazz || QName.class == clazz) {
            return data;
        }
        DataBinding javaBeansDataBinding = this.dataBindings.getDataBinding("java:complexType");
        DataBinding jaxbDataBinding = this.dataBindings.getDataBinding("javax.xml.bind.JAXBElement");
        DataBinding dataBinding = this.dataBindings.getDataBinding(dataType.getDataBinding());
        if (dataBinding == null) {
            String db;
            dataType = this.dataBindings.introspectType(data, operation);
            if (dataType != null && (dataBinding = this.dataBindings.getDataBinding(db = dataType.getDataBinding())) == null && db != null) {
                return data;
            }
            if (dataBinding == null) {
                dataBinding = this.dataBindings.getDataBinding("java:complexType");
            }
        }
        if (dataBinding == javaBeansDataBinding) {
            clazz = data.getClass();
            if (clazz.isArray()) {
                Object element;
                if (Array.getLength(data) != 0 && (element = Array.get(data, 0)) != null && !(element instanceof Serializable)) {
                    dataBinding = jaxbDataBinding;
                }
            } else if (!(data instanceof Serializable) && !(data instanceof Cloneable)) {
                dataBinding = jaxbDataBinding;
            }
        }
        if (dataBinding != null) {
            return dataBinding.copy(data, dataType, operation);
        }
        return data;
    }

    @Override
    public Object copyInput(Object input, Operation operation) {
        Object[] objectArray;
        if (input == null) {
            return null;
        }
        if (input instanceof Object[]) {
            objectArray = (Object[])input;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = input;
        }
        Object[] data = objectArray;
        List inputTypes = (List)operation.getInputType().getLogical();
        Object[] copy = new Object[data.length];
        IdentityHashMap map = new IdentityHashMap();
        int size = inputTypes.size();
        for (int i = 0; i < size; ++i) {
            Object arg = data[i];
            if (arg == null) {
                copy[i] = null;
                continue;
            }
            Object copiedArg = map.get(arg);
            if (copiedArg != null) {
                copy[i] = copiedArg;
                continue;
            }
            copiedArg = this.copy(arg, (DataType)inputTypes.get(i));
            map.put(arg, copiedArg);
            copy[i] = copiedArg;
        }
        return copy;
    }

    @Override
    public Object copyOutput(Object data, Operation operation) {
        return this.copy(data, operation.getOutputType(), operation);
    }

    @Override
    public Object copyFault(Object fault, Operation operation) {
        if (this.faultExceptionMapper == null) {
            this.faultExceptionMapper = (FaultExceptionMapper)((UtilityExtensionPoint)this.registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(FaultExceptionMapper.class);
            if (this.faultExceptionMapper == null) {
                return fault;
            }
        }
        for (DataType et : operation.getFaultTypes()) {
            if (!et.getPhysical().isInstance(fault)) continue;
            Throwable ex = (Throwable)fault;
            DataTypeImpl exType = new DataTypeImpl(ex.getClass(), (Object)new DataTypeImpl(ex.getClass(), (Object)XMLType.UNKNOWN));
            this.faultExceptionMapper.introspectFaultDataType((DataType)exType, operation, false);
            DataType faultType = (DataType)exType.getLogical();
            Object faultInfo = this.faultExceptionMapper.getFaultInfo(ex, faultType.getPhysical(), operation);
            faultInfo = this.copy(faultInfo, faultType);
            fault = this.faultExceptionMapper.wrapFaultInfo((DataType)exType, ex.getMessage(), faultInfo, ex.getCause(), operation);
            return fault;
        }
        return fault;
    }
}

