/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.XMLTypeHelper;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public class DefaultDataBindingExtensionPoint
implements DataBindingExtensionPoint {
    private ExtensionPointRegistry registry;
    private final Map<String, DataBinding> bindings = new HashMap<String, DataBinding>();
    private final List<DataBinding> databindings = new ArrayList<DataBinding>();
    private static final Logger logger = Logger.getLogger(DefaultDataBindingExtensionPoint.class.getName());
    private boolean loadedDataBindings;

    public DefaultDataBindingExtensionPoint() {
    }

    public DefaultDataBindingExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    public DataBinding getDataBinding(String id) {
        if (id == null) {
            return null;
        }
        DataBinding dataBinding = this.bindings.get(id.toLowerCase());
        if (dataBinding == null) {
            this.loadDataBindings();
            dataBinding = this.bindings.get(id.toLowerCase());
        }
        return dataBinding;
    }

    public void addDataBinding(DataBinding dataBinding) {
        if (logger.isLoggable(Level.FINE)) {
            String className = dataBinding.getClass().getName();
            boolean lazy = false;
            if (dataBinding instanceof LazyDataBinding) {
                className = ((LazyDataBinding)dataBinding).dataBindingDeclaration.getClassName();
                lazy = true;
            }
            logger.fine("Adding databinding: " + className + ";name=" + dataBinding.getName() + ",lazy=" + lazy);
        }
        this.databindings.add(dataBinding);
        this.bindings.put(dataBinding.getName().toLowerCase(), dataBinding);
    }

    public DataBinding removeDataBinding(String id) {
        if (id == null) {
            return null;
        }
        DataBinding dataBinding = this.bindings.remove(id.toLowerCase());
        if (dataBinding != null) {
            this.databindings.remove(dataBinding);
        }
        return dataBinding;
    }

    private synchronized void loadDataBindings() {
        Set dataBindingDeclarations;
        if (this.loadedDataBindings) {
            return;
        }
        try {
            dataBindingDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(DataBinding.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration dataBindingDeclaration : dataBindingDeclarations) {
            Map attributes = dataBindingDeclaration.getAttributes();
            String name = (String)attributes.get("name");
            LazyDataBinding dataBinding = new LazyDataBinding(name, dataBindingDeclaration);
            this.addDataBinding(dataBinding);
        }
        this.loadedDataBindings = true;
    }

    public boolean introspectType(DataType dataType, Operation operation) {
        this.loadDataBindings();
        for (DataBinding binding : this.databindings) {
            if (binding.getName().equals("java:complexType") || !binding.introspect(dataType, operation)) continue;
            return true;
        }
        Class physical = dataType.getPhysical();
        if (physical == Object.class) {
            dataType.setDataBinding("java:complexType");
            return false;
        }
        if (dataType.getPhysical().isArray()) {
            this.introspectArray(dataType, operation);
            return true;
        }
        if (Throwable.class.isAssignableFrom(physical)) {
            dataType.setDataBinding("java:exception");
            return true;
        }
        dataType.setDataBinding("java:complexType");
        return false;
    }

    private boolean introspectArray(DataType dataType, Operation operation) {
        Class physical = dataType.getPhysical();
        if (!physical.isArray() || physical == byte[].class) {
            return false;
        }
        Class<?> componentType = physical.getComponentType();
        DataTypeImpl logical = new DataTypeImpl(componentType, dataType.getLogical());
        this.introspectType((DataType)logical, operation);
        dataType.setDataBinding("java:array");
        dataType.setLogical((Object)logical);
        return true;
    }

    public DataType introspectType(Object value, Operation operation) {
        this.loadDataBindings();
        DataType dataType = null;
        for (DataBinding binding : this.databindings) {
            if (!binding.getName().equals("java:complexType")) {
                dataType = binding.introspect(value, operation);
            }
            if (dataType == null) continue;
            return dataType;
        }
        return new DataTypeImpl("java:complexType", value.getClass(), (Object)XMLType.UNKNOWN);
    }

    private class LazyDataBinding
    implements DataBinding {
        private String name;
        private ServiceDeclaration dataBindingDeclaration;
        private DataBinding dataBinding;

        private LazyDataBinding(String type, ServiceDeclaration dataBindingDeclaration) {
            this.name = type;
            this.dataBindingDeclaration = dataBindingDeclaration;
        }

        private DataBinding getDataBinding() {
            if (this.dataBinding == null) {
                try {
                    Class dataBindingClass = this.dataBindingDeclaration.loadClass();
                    try {
                        Constructor constructor = dataBindingClass.getConstructor(new Class[0]);
                        this.dataBinding = (DataBinding)constructor.newInstance(new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        Constructor constructor = dataBindingClass.getConstructor(ExtensionPointRegistry.class);
                        this.dataBinding = (DataBinding)constructor.newInstance(DefaultDataBindingExtensionPoint.this.registry);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.dataBinding;
        }

        public Object copy(Object object, DataType dataType, Operation operation) {
            return this.getDataBinding().copy(object, dataType, operation);
        }

        public String getName() {
            return this.name;
        }

        public XMLTypeHelper getXMLTypeHelper() {
            return this.getDataBinding().getXMLTypeHelper();
        }

        public WrapperHandler getWrapperHandler() {
            return this.getDataBinding().getWrapperHandler();
        }

        public boolean introspect(DataType dataType, Operation operation) {
            return this.getDataBinding().introspect(dataType, operation);
        }

        public DataType introspect(Object value, Operation operation) {
            return this.getDataBinding().introspect(value, operation);
        }
    }
}

