/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.provider;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.provider.OperationSelectorProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProviderFactory;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.PolicyProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProviderFactoryExtensionPoint
implements ProviderFactoryExtensionPoint {
    private ExtensionPointRegistry registry;
    private final Map<Class<?>, ProviderFactory> providerFactories = new HashMap();
    private final List<PolicyProviderFactory> policyProviderFactories = new ArrayList<PolicyProviderFactory>();
    private boolean loaded;

    public DefaultProviderFactoryExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addProviderFactory(ProviderFactory providerFactory) {
        if (providerFactory instanceof PolicyProviderFactory) {
            this.policyProviderFactories.add((PolicyProviderFactory)providerFactory);
        }
        this.providerFactories.put(providerFactory.getModelType(), providerFactory);
    }

    @Override
    public void removeProviderFactory(ProviderFactory providerFactory) {
        if (providerFactory instanceof PolicyProviderFactory) {
            this.policyProviderFactories.remove((PolicyProviderFactory)providerFactory);
        }
        this.providerFactories.remove(providerFactory.getModelType());
    }

    @Override
    public ProviderFactory getProviderFactory(Class<?> modelType) {
        Class<?>[] classes;
        this.loadProviderFactories();
        for (Class<?> c : classes = modelType.getInterfaces()) {
            ProviderFactory factory = this.providerFactories.get(c);
            if (factory == null) continue;
            return factory;
        }
        return this.providerFactories.get(modelType);
    }

    @Override
    public List<PolicyProviderFactory> getPolicyProviderFactories() {
        this.loadProviderFactories();
        return this.policyProviderFactories;
    }

    private synchronized void loadProviderFactories() {
        if (this.loaded) {
            return;
        }
        this.loadProviderFactories(BindingProviderFactory.class);
        this.loadProviderFactories(ImplementationProviderFactory.class);
        this.loadProviderFactories(PolicyProviderFactory.class);
        this.loadProviderFactories(WireFormatProviderFactory.class);
        this.loadProviderFactories(OperationSelectorProviderFactory.class);
        this.loaded = true;
    }

    private List<ProviderFactory> loadProviderFactories(Class<?> factoryClass) {
        Set factoryDeclarations;
        ServiceDiscovery serviceDiscovery = ServiceDiscovery.getInstance();
        try {
            factoryDeclarations = serviceDiscovery.getServiceDeclarations(factoryClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        ProviderFactoryExtensionPoint factoryExtensionPoint = (ProviderFactoryExtensionPoint)this.registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        ArrayList<ProviderFactory> factories = new ArrayList<ProviderFactory>();
        for (ServiceDeclaration factoryDeclaration : factoryDeclarations) {
            ProviderFactory factory;
            String modelTypeName;
            Map attributes = factoryDeclaration.getAttributes();
            if (factoryClass == ImplementationProviderFactory.class) {
                modelTypeName = (String)attributes.get("model");
                factory = new LazyImplementationProviderFactory(this.registry, modelTypeName, factoryDeclaration);
                factoryExtensionPoint.addProviderFactory(factory);
                factories.add(factory);
                continue;
            }
            if (factoryClass == BindingProviderFactory.class) {
                modelTypeName = (String)attributes.get("model");
                factory = new LazyBindingProviderFactory(this.registry, modelTypeName, factoryDeclaration);
                factoryExtensionPoint.addProviderFactory(factory);
                factories.add(factory);
                continue;
            }
            if (factoryClass == PolicyProviderFactory.class) {
                modelTypeName = (String)attributes.get("model");
                factory = new LazyPolicyProviderFactory(this.registry, modelTypeName, factoryDeclaration);
                factoryExtensionPoint.addProviderFactory(factory);
                factories.add(factory);
                continue;
            }
            if (factoryClass == WireFormatProviderFactory.class) {
                modelTypeName = (String)attributes.get("model");
                factory = new LazyWireFormatProviderFactory(this.registry, modelTypeName, factoryDeclaration);
                factoryExtensionPoint.addProviderFactory(factory);
                factories.add(factory);
                continue;
            }
            if (factoryClass != OperationSelectorProviderFactory.class) continue;
            modelTypeName = (String)attributes.get("model");
            factory = new LazyOperationSelectorProviderFactory(this.registry, modelTypeName, factoryDeclaration);
            factoryExtensionPoint.addProviderFactory(factory);
            factories.add(factory);
        }
        return factories;
    }

    private class LazyOperationSelectorProviderFactory
    implements OperationSelectorProviderFactory {
        private ExtensionPointRegistry registry;
        private String modelTypeName;
        private ServiceDeclaration providerClass;
        private OperationSelectorProviderFactory factory;
        private Class modelType;

        private LazyOperationSelectorProviderFactory(ExtensionPointRegistry registry, String modelTypeName, ServiceDeclaration providerClass) {
            this.registry = registry;
            this.modelTypeName = modelTypeName;
            this.providerClass = providerClass;
        }

        private OperationSelectorProviderFactory getFactory() {
            if (this.factory == null) {
                try {
                    Class factoryClass = this.providerClass.loadClass();
                    Constructor constructor = factoryClass.getConstructor(ExtensionPointRegistry.class);
                    this.factory = (OperationSelectorProviderFactory)constructor.newInstance(this.registry);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.factory;
        }

        public OperationSelectorProvider createReferenceOperationSelectorProvider(RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
            return this.getFactory().createReferenceOperationSelectorProvider(component, reference, binding);
        }

        public OperationSelectorProvider createServiceOperationSelectorProvider(RuntimeComponent component, RuntimeComponentService service, Binding binding) {
            return this.getFactory().createServiceOperationSelectorProvider(component, service, binding);
        }

        public Class getModelType() {
            if (this.modelType == null) {
                try {
                    this.modelType = this.providerClass.loadClass(this.modelTypeName);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.modelType;
        }
    }

    private class LazyWireFormatProviderFactory
    implements WireFormatProviderFactory {
        private ExtensionPointRegistry registry;
        private String modelTypeName;
        private ServiceDeclaration providerClass;
        private WireFormatProviderFactory factory;
        private Class modelType;

        private LazyWireFormatProviderFactory(ExtensionPointRegistry registry, String modelTypeName, ServiceDeclaration providerClass) {
            this.registry = registry;
            this.modelTypeName = modelTypeName;
            this.providerClass = providerClass;
        }

        private WireFormatProviderFactory getFactory() {
            if (this.factory == null) {
                try {
                    Class factoryClass = this.providerClass.loadClass();
                    Constructor constructor = factoryClass.getConstructor(ExtensionPointRegistry.class);
                    this.factory = (WireFormatProviderFactory)constructor.newInstance(this.registry);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.factory;
        }

        public WireFormatProvider createReferenceWireFormatProvider(RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
            return this.getFactory().createReferenceWireFormatProvider(component, reference, binding);
        }

        public WireFormatProvider createServiceWireFormatProvider(RuntimeComponent component, RuntimeComponentService service, Binding binding) {
            return this.getFactory().createServiceWireFormatProvider(component, service, binding);
        }

        public Class getModelType() {
            if (this.modelType == null) {
                try {
                    this.modelType = this.providerClass.loadClass(this.modelTypeName);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.modelType;
        }
    }

    private class LazyPolicyProviderFactory
    implements PolicyProviderFactory {
        private ExtensionPointRegistry registry;
        private String modelTypeName;
        private ServiceDeclaration providerClass;
        private PolicyProviderFactory factory;
        private Class modelType;

        private LazyPolicyProviderFactory(ExtensionPointRegistry registry, String modelTypeName, ServiceDeclaration providerClass) {
            this.registry = registry;
            this.modelTypeName = modelTypeName;
            this.providerClass = providerClass;
        }

        private PolicyProviderFactory getFactory() {
            if (this.factory == null) {
                try {
                    Class factoryClass = this.providerClass.loadClass();
                    Constructor constructor = factoryClass.getConstructor(ExtensionPointRegistry.class);
                    this.factory = (PolicyProviderFactory)constructor.newInstance(this.registry);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.factory;
        }

        public PolicyProvider createImplementationPolicyProvider(RuntimeComponent component, Implementation implementation) {
            return this.getFactory().createImplementationPolicyProvider(component, implementation);
        }

        public PolicyProvider createReferencePolicyProvider(RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
            return this.getFactory().createReferencePolicyProvider(component, reference, binding);
        }

        public PolicyProvider createServicePolicyProvider(RuntimeComponent component, RuntimeComponentService service, Binding binding) {
            return this.getFactory().createServicePolicyProvider(component, service, binding);
        }

        public Class getModelType() {
            if (this.modelType == null) {
                try {
                    this.modelType = this.providerClass.loadClass(this.modelTypeName);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.modelType;
        }
    }

    private class LazyImplementationProviderFactory
    implements ImplementationProviderFactory {
        private ExtensionPointRegistry registry;
        private String modelTypeName;
        private ServiceDeclaration providerClass;
        private ImplementationProviderFactory factory;
        private Class modelType;

        private LazyImplementationProviderFactory(ExtensionPointRegistry registry, String modelTypeName, ServiceDeclaration providerClass) {
            this.registry = registry;
            this.modelTypeName = modelTypeName;
            this.providerClass = providerClass;
        }

        private ImplementationProviderFactory getFactory() {
            if (this.factory == null) {
                try {
                    Class factoryClass = this.providerClass.loadClass();
                    Constructor constructor = factoryClass.getConstructor(ExtensionPointRegistry.class);
                    this.factory = (ImplementationProviderFactory)constructor.newInstance(this.registry);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.factory;
        }

        public ImplementationProvider createImplementationProvider(RuntimeComponent component, Implementation Implementation2) {
            return this.getFactory().createImplementationProvider(component, Implementation2);
        }

        public Class getModelType() {
            if (this.modelType == null) {
                try {
                    this.modelType = this.providerClass.loadClass(this.modelTypeName);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.modelType;
        }
    }

    private static class LazyBindingProviderFactory
    implements BindingProviderFactory {
        private ExtensionPointRegistry registry;
        private String modelTypeName;
        private ServiceDeclaration factoryDeclaration;
        private BindingProviderFactory factory;
        private Class modelType;

        private LazyBindingProviderFactory(ExtensionPointRegistry registry, String modelTypeName, ServiceDeclaration factoryDeclaration) {
            this.registry = registry;
            this.modelTypeName = modelTypeName;
            this.factoryDeclaration = factoryDeclaration;
        }

        private BindingProviderFactory getFactory() {
            if (this.factory == null) {
                try {
                    Class factoryClass = this.factoryDeclaration.loadClass();
                    Constructor constructor = factoryClass.getConstructor(ExtensionPointRegistry.class);
                    this.factory = (BindingProviderFactory)constructor.newInstance(this.registry);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.factory;
        }

        public ReferenceBindingProvider createReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
            return this.getFactory().createReferenceBindingProvider(component, reference, binding);
        }

        public ServiceBindingProvider createServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, Binding binding) {
            return this.getFactory().createServiceBindingProvider(component, service, binding);
        }

        public Class getModelType() {
            if (this.modelType == null) {
                try {
                    this.modelType = this.factoryDeclaration.loadClass(this.modelTypeName);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.modelType;
        }
    }
}

