/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpointresolver;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.endpointresolver.EndpointResolver;
import org.apache.tuscany.sca.endpointresolver.EndpointResolverFactory;
import org.apache.tuscany.sca.endpointresolver.EndpointResolverFactoryExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEndpointResolverFactoryExtensionPoint
implements EndpointResolverFactoryExtensionPoint {
    private ExtensionPointRegistry registry;
    private final Map<Class<?>, EndpointResolverFactory> endpointResolverFactories = new HashMap();
    private boolean loaded;

    public DefaultEndpointResolverFactoryExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addEndpointResolverFactory(EndpointResolverFactory endpointResolverFactory) {
        this.endpointResolverFactories.put(endpointResolverFactory.getModelType(), endpointResolverFactory);
    }

    @Override
    public void removeEndpointResolverFactory(EndpointResolverFactory endpointResolverFactory) {
        this.endpointResolverFactories.remove(endpointResolverFactory.getModelType());
    }

    @Override
    public EndpointResolverFactory getEndpointResolverFactory(Class<?> modelType) {
        Class<?>[] classes;
        this.loadProviderFactories();
        for (Class<?> c : classes = modelType.getInterfaces()) {
            EndpointResolverFactory factory = this.endpointResolverFactories.get(c);
            if (factory == null) continue;
            return factory;
        }
        return this.endpointResolverFactories.get(modelType);
    }

    private synchronized void loadProviderFactories() {
        Set factoryDeclarations;
        if (this.loaded) {
            return;
        }
        ServiceDiscovery serviceDiscovery = ServiceDiscovery.getInstance();
        try {
            factoryDeclarations = serviceDiscovery.getServiceDeclarations(EndpointResolverFactory.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        EndpointResolverFactoryExtensionPoint factoryExtensionPoint = (EndpointResolverFactoryExtensionPoint)this.registry.getExtensionPoint(EndpointResolverFactoryExtensionPoint.class);
        ArrayList<LazyEndpointResolverFactory> factories = new ArrayList<LazyEndpointResolverFactory>();
        for (ServiceDeclaration factoryDeclaration : factoryDeclarations) {
            Map attributes = factoryDeclaration.getAttributes();
            String modelTypeName = (String)attributes.get("model");
            LazyEndpointResolverFactory factory = new LazyEndpointResolverFactory(this.registry, modelTypeName, factoryDeclaration);
            factoryExtensionPoint.addEndpointResolverFactory(factory);
            factories.add(factory);
        }
        this.loaded = true;
    }

    private class LazyEndpointResolverFactory
    implements EndpointResolverFactory {
        private ExtensionPointRegistry registry;
        private String modelTypeName;
        private ServiceDeclaration providerClass;
        private EndpointResolverFactory factory;
        private Class modelType;

        private LazyEndpointResolverFactory(ExtensionPointRegistry registry, String modelTypeName, ServiceDeclaration providerClass) {
            this.registry = registry;
            this.modelTypeName = modelTypeName;
            this.providerClass = providerClass;
        }

        private EndpointResolverFactory getFactory() {
            if (this.factory == null) {
                try {
                    Class factoryClass = this.providerClass.loadClass();
                    Constructor constructor = factoryClass.getConstructor(ExtensionPointRegistry.class);
                    this.factory = (EndpointResolverFactory)constructor.newInstance(this.registry);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.factory;
        }

        public EndpointResolver createEndpointResolver(Endpoint endpoint, Binding binding) {
            return this.getFactory().createEndpointResolver(endpoint, binding);
        }

        public Class getModelType() {
            if (this.modelType == null) {
                try {
                    this.modelType = this.providerClass.loadClass(this.modelTypeName);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.modelType;
        }
    }
}

