/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.provider;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.provider.SCADefinitionsProvider;
import org.apache.tuscany.sca.provider.SCADefinitionsProviderExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSCADefinitionsProviderExtensionPoint
implements SCADefinitionsProviderExtensionPoint {
    private ExtensionPointRegistry extensionPointRegistry = null;
    private List<SCADefinitionsProvider> scaDefnsProviders = new ArrayList<SCADefinitionsProvider>();

    public DefaultSCADefinitionsProviderExtensionPoint(ExtensionPointRegistry extnPtReg) {
        this.extensionPointRegistry = extnPtReg;
    }

    @Override
    public void addSCADefinitionsProvider(SCADefinitionsProvider provider) {
        this.scaDefnsProviders.add(provider);
    }

    @Override
    public void removeSCADefinitionsProvider(SCADefinitionsProvider provider) {
        this.scaDefnsProviders.remove(provider);
    }

    @Override
    public List<SCADefinitionsProvider> getSCADefinitionsProviders() {
        if (this.scaDefnsProviders.isEmpty()) {
            this.loadProviders();
        }
        return this.scaDefnsProviders;
    }

    private void loadProviders() {
        SCADefinitionsProvider aProvider = null;
        Class providerClass = null;
        Constructor constructor = null;
        try {
            Set defnProviderDecls = ServiceDiscovery.getInstance().getServiceDeclarations(SCADefinitionsProvider.class);
            for (ServiceDeclaration aDefnProviderDecl : defnProviderDecls) {
                providerClass = aDefnProviderDecl.loadClass();
                try {
                    constructor = providerClass.getConstructor(new Class[0]);
                    aProvider = (SCADefinitionsProvider)constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    constructor = providerClass.getConstructor(ExtensionPointRegistry.class);
                    aProvider = (SCADefinitionsProvider)constructor.newInstance(this.extensionPointRegistry);
                }
                this.scaDefnsProviders.add(aProvider);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

