/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.wire;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.Invocable;

public class DataTransformationInterceptor
extends InterceptorAsyncImpl {
    private Operation sourceOperation;
    private Operation targetOperation;
    private Invocable invocable;
    private Mediator mediator;

    public DataTransformationInterceptor(Invocable invocable, Operation sourceOperation, Operation targetOperation, Mediator mediator) {
        this.sourceOperation = sourceOperation;
        this.targetOperation = targetOperation;
        if (sourceOperation instanceof JavaOperation) {
            JavaOperation javaOp = (JavaOperation)sourceOperation;
            Method sourceMethod = javaOp.getJavaMethod();
        }
        this.mediator = mediator;
        this.invocable = invocable;
    }

    public Message processRequest(Message msg) {
        HashMap<String, Invocable> metadata = new HashMap<String, Invocable>();
        metadata.put(Invocable.class.getName(), this.invocable);
        Object input = this.mediator.mediateInput(msg.getBody(), this.sourceOperation, this.targetOperation, metadata);
        msg.setBody(input);
        return msg;
    }

    public Message processResponse(Message msg) {
        Message resultMsg = msg;
        HashMap<String, Invocable> metadata = new HashMap<String, Invocable>();
        metadata.put(Invocable.class.getName(), this.invocable);
        if (this.sourceOperation.isNonBlocking()) {
            return resultMsg;
        }
        Object result = resultMsg.getBody();
        if (resultMsg.isFault()) {
            Object transformedFault = null;
            if (result instanceof Exception && !(result instanceof RuntimeException) && (transformedFault = this.mediator.mediateFault(result, this.sourceOperation, this.targetOperation, metadata)) != result) {
                resultMsg.setFaultBody(transformedFault);
            }
        } else {
            assert (!(result instanceof Throwable)) : "Expected messages that are not throwable " + result;
            Object newResult = this.mediator.mediateOutput(result, this.sourceOperation, this.targetOperation, metadata);
            resultMsg.setBody(newResult);
        }
        return resultMsg;
    }

    protected List<DataType<DataType>> getHolderTypes(DataType<List<DataType>> inputTypes) {
        List logicalType;
        ArrayList<DataType<DataType>> returnTypes = new ArrayList<DataType<DataType>>();
        if (inputTypes != null && (logicalType = (List)inputTypes.getLogical()) != null) {
            for (int i = 0; i < logicalType.size(); ++i) {
                DataType dataType = (DataType)logicalType.get(i);
                if (!DataTransformationInterceptor.isHolder(dataType.getGenericType())) continue;
                returnTypes.add((DataType<DataType>)dataType);
            }
        }
        return returnTypes;
    }

    protected static boolean isHolder(Type type) {
        String typeString = type.toString();
        return typeString.startsWith("javax.xml.ws.Holder");
    }
}

