/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.wire;

import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.databinding.wire.DataTransformationInterceptor;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.util.OperationDataBindingHelper;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;

public class DataBindingRuntimeWireProcessor
implements RuntimeWireProcessor {
    private Mediator mediator;

    public DataBindingRuntimeWireProcessor(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public void process(RuntimeEndpoint endpoint) {
        InterfaceContract sourceContract = endpoint.getBindingInterfaceContract();
        InterfaceContract targetContract = endpoint.getComponentTypeServiceInterfaceContract();
        if (targetContract == null) {
            targetContract = sourceContract;
        }
        if (!sourceContract.getInterface().isRemotable()) {
            return;
        }
        List chains = endpoint.getInvocationChains();
        for (InvocationChain chain : chains) {
            Operation sourceOperation = chain.getSourceOperation();
            Operation targetOperation = chain.getTargetOperation();
            DataTransformationInterceptor interceptor = null;
            if (this.isTransformationRequired(sourceContract, sourceOperation, targetContract, targetOperation)) {
                interceptor = new DataTransformationInterceptor((Invocable)endpoint, sourceOperation, targetOperation, this.mediator);
            }
            if (interceptor == null) continue;
            String phase = "service.interface";
            chain.addInterceptor(phase, interceptor);
        }
    }

    public void process(RuntimeEndpointReference endpointReference) {
        InterfaceContract sourceContract = endpointReference.getComponentTypeReferenceInterfaceContract();
        InterfaceContract targetContract = endpointReference.getBindingInterfaceContract();
        if (targetContract == null) {
            targetContract = sourceContract;
        }
        if (sourceContract == null || !sourceContract.getInterface().isRemotable()) {
            return;
        }
        List chains = endpointReference.getInvocationChains();
        for (InvocationChain chain : chains) {
            Operation sourceOperation = chain.getSourceOperation();
            Operation targetOperation = chain.getTargetOperation();
            DataTransformationInterceptor interceptor = null;
            if (this.isTransformationRequired(sourceContract, sourceOperation, targetContract, targetOperation)) {
                interceptor = new DataTransformationInterceptor((Invocable)endpointReference, sourceOperation, targetOperation, this.mediator);
            }
            if (interceptor == null) continue;
            String phase = "reference.interface";
            chain.addInterceptor(phase, interceptor);
        }
    }

    private boolean isTransformationRequired(InterfaceContract sourceContract, Operation sourceOperation, InterfaceContract targetContract, Operation targetOperation) {
        if (targetContract == null) {
            targetContract = sourceContract;
        }
        if (sourceContract == targetContract) {
            return false;
        }
        return OperationDataBindingHelper.isTransformationRequired((Operation)sourceOperation, (Operation)targetOperation);
    }
}

