/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;

public class Output2OutputTransformer
extends BaseTransformer<Object, Object>
implements PullTransformer<Object, Object> {
    protected Mediator mediator;

    public Output2OutputTransformer(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public String getSourceDataBinding() {
        return "idl:output";
    }

    public String getTargetDataBinding() {
        return "idl:output";
    }

    protected Class<Object> getSourceType() {
        return Object.class;
    }

    protected Class<Object> getTargetType() {
        return Object.class;
    }

    public int getWeight() {
        return 10;
    }

    private String getDataBinding(Operation operation) {
        WrapperInfo wrapper = operation.getOutputWrapper();
        if (wrapper != null) {
            return wrapper.getDataBinding();
        }
        return null;
    }

    private WrapperHandler getWrapperHandler(String dataBindingId, boolean required) {
        WrapperHandler wrapperHandler = null;
        if (dataBindingId != null) {
            DataBinding dataBinding = this.mediator.getDataBindings().getDataBinding(dataBindingId);
            WrapperHandler wrapperHandler2 = wrapperHandler = dataBinding == null ? null : dataBinding.getWrapperHandler();
        }
        if (wrapperHandler == null && required) {
            throw new TransformationException("No wrapper handler is provided for databinding: " + dataBindingId);
        }
        return wrapperHandler;
    }

    private boolean matches(WrapperInfo w1, WrapperInfo w2) {
        if (w1 == null || w2 == null) {
            return false;
        }
        if (!w1.getWrapperElement().equals((Object)w2.getWrapperElement())) {
            return false;
        }
        List list1 = w1.getChildElements();
        List list2 = w2.getChildElements();
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            String n1 = ((ElementInfo)list1.get(i)).getQName().getLocalPart();
            String n2 = ((ElementInfo)list2.get(i)).getQName().getLocalPart();
            if (Output2OutputTransformer.stripLeadingUnderscore(n1).equals(Output2OutputTransformer.stripLeadingUnderscore(n2))) continue;
            return false;
        }
        return true;
    }

    private static String stripLeadingUnderscore(String name) {
        return name.startsWith("_") ? name.substring(1) : name;
    }

    public Object transform(Object response, TransformationContext context) {
        try {
            DataType sourceType = context.getSourceDataType();
            Operation sourceOp = context.getSourceOperation();
            boolean sourceWrapped = sourceOp != null && sourceOp.isOutputWrapperStyle() && sourceOp.getOutputWrapper() != null;
            boolean sourceNotSubjectToWrapping = sourceOp != null && sourceOp.isNotSubjectToWrapping();
            WrapperHandler sourceWrapperHandler = null;
            String sourceDataBinding = this.getDataBinding(sourceOp);
            sourceWrapperHandler = this.getWrapperHandler(sourceDataBinding, sourceWrapped);
            DataType targetType = context.getTargetDataType();
            Operation targetOp = context.getTargetOperation();
            boolean targetWrapped = targetOp != null && targetOp.isOutputWrapperStyle() && targetOp.getOutputWrapper() != null;
            boolean targetNotSubjectToWrapping = targetOp != null && targetOp.isNotSubjectToWrapping();
            WrapperHandler targetWrapperHandler = null;
            String targetDataBinding = this.getDataBinding(targetOp);
            targetWrapperHandler = this.getWrapperHandler(targetDataBinding, targetWrapped);
            if (!sourceWrapped && !sourceNotSubjectToWrapping && targetWrapped) {
                WrapperInfo wrapper = targetOp.getOutputWrapper();
                ElementInfo wrapperElement = wrapper.getWrapperElement();
                List childElements = wrapper.getChildElements();
                Class targetWrapperClass = wrapper != null ? wrapper.getWrapperClass() : null;
                Object[] outputs = null;
                outputs = !sourceOp.hasArrayWrappedOutput() ? new Object[]{response} : (Object[])response;
                if (sourceWrapperHandler != null) {
                    DataType sourceWrapperType;
                    WrapperInfo sourceWrapperInfo = sourceOp.getOutputWrapper();
                    DataType dataType = sourceWrapperType = sourceWrapperInfo != null ? sourceWrapperInfo.getWrapperType() : null;
                    if (sourceWrapperType != null && this.matches(sourceOp.getOutputWrapper(), targetOp.getOutputWrapper())) {
                        Class sourceWrapperClass = sourceWrapperType.getPhysical();
                        Object sourceWrapper = sourceWrapperHandler.create(sourceOp, false);
                        if (sourceWrapper != null) {
                            if (!childElements.isEmpty()) {
                                sourceWrapperHandler.setChildren(sourceWrapper, outputs, sourceOp, false);
                            }
                            Object targetWrapper = this.mediator.mediate(sourceWrapper, sourceWrapperType, (DataType)((List)targetType.getLogical()).get(0), context.getMetadata());
                            return targetWrapper;
                        }
                    }
                }
                Object targetWrapper = targetWrapperHandler.create(targetOp, false);
                if (childElements.isEmpty()) {
                    return targetWrapper;
                }
                Object[] targetChildren = new Object[outputs.length];
                for (int i = 0; i < outputs.length; ++i) {
                    DataType targetOutputType = (DataType)((List)wrapper.getUnwrappedType().getLogical()).get(i);
                    targetChildren[i] = this.mediator.mediate(outputs[i], (DataType)((List)sourceType.getLogical()).get(i), targetOutputType, context.getMetadata());
                }
                targetWrapperHandler.setChildren(targetWrapper, targetChildren, targetOp, false);
                return targetWrapper;
            }
            if (sourceWrapped && !targetWrapped && !targetNotSubjectToWrapping) {
                Object sourceWrapper = response;
                List childElements = sourceOp.getOutputWrapper().getChildElements();
                if (childElements.isEmpty()) {
                    return null;
                }
                if (targetWrapperHandler != null) {
                    ElementInfo wrapperElement = sourceOp.getOutputWrapper().getWrapperElement();
                    if (sourceWrapperHandler.isInstance(sourceWrapper, sourceOp, false)) {
                        DataType targetWrapperType;
                        WrapperInfo targetWrapperInfo = targetOp.getOutputWrapper();
                        DataType dataType = targetWrapperType = targetWrapperInfo != null ? targetWrapperInfo.getWrapperType() : null;
                        if (targetWrapperType != null && this.matches(sourceOp.getOutputWrapper(), targetOp.getOutputWrapper())) {
                            Object targetWrapper = this.mediator.mediate(sourceWrapper, (DataType)((List)sourceType.getLogical()).get(0), targetWrapperType, context.getMetadata());
                            List targetChildren = targetWrapperHandler.getChildren(targetWrapper, targetOp, false);
                            if (targetOp.hasArrayWrappedOutput()) {
                                return targetChildren.toArray();
                            }
                            return targetChildren.get(0);
                        }
                    }
                }
                Object[] sourceChildren = sourceWrapperHandler.getChildren(sourceWrapper, sourceOp, false).toArray();
                Object[] target = new Object[sourceChildren.length];
                for (int i = 0; i < sourceChildren.length; ++i) {
                    DataType childType = (DataType)((List)sourceOp.getOutputWrapper().getUnwrappedType().getLogical()).get(i);
                    target[i] = this.mediator.mediate(sourceChildren[i], childType, (DataType)((List)targetType.getLogical()).get(i), context.getMetadata());
                }
                if (targetOp.hasArrayWrappedOutput()) {
                    return target;
                }
                if (target.length > 1) {
                    throw new IllegalStateException("Expecting only one output based on Operation model, found: " + target.length + " # of outputs.");
                }
                return target[0];
            }
            Object[] outputs = null;
            outputs = !sourceOp.hasArrayWrappedOutput() ? new Object[]{response} : (Object[])response;
            Object[] target = new Object[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                Object child;
                target[i] = child = this.mediator.mediate(outputs[i], (DataType)((List)sourceType.getLogical()).get(i), (DataType)((List)targetType.getLogical()).get(i), context.getMetadata());
            }
            if (targetOp.hasArrayWrappedOutput()) {
                return target;
            }
            if (target.length > 1) {
                throw new IllegalStateException("Expecting only one output based on Operation model, found: " + target.length + " # of outputs.");
            }
            return target[0];
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
    }
}

