/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.util.Iterator;
import java.util.Map;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.interfacedef.DataType;

public class Map2MapTransformer
extends BaseTransformer<Map, Map>
implements PullTransformer<Map, Map> {
    private static final String JAVA_MAP = "java:map";
    protected Mediator mediator;

    public Map2MapTransformer(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public String getSourceDataBinding() {
        return JAVA_MAP;
    }

    public String getTargetDataBinding() {
        return JAVA_MAP;
    }

    protected Class<Map> getSourceType() {
        return Map.class;
    }

    protected Class<Map> getTargetType() {
        return Map.class;
    }

    public int getWeight() {
        return 10;
    }

    public Map transform(Map sourceMap, TransformationContext context) {
        try {
            if (sourceMap == null) {
                return null;
            }
            DataType sourceType = context.getSourceDataType();
            DataType targetType = context.getTargetDataType();
            Map targetMap = this.createMap(targetType.getPhysical());
            Iterator i$ = sourceMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry sourceItem;
                Map.Entry entry = sourceItem = i$.next();
                Object targetValue = this.mediator.mediate(entry.getValue(), (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
                targetMap.put(entry.getKey(), targetValue);
            }
            return targetMap;
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
    }

    private Map createMap(Class<?> collectionClass) throws Exception {
        return (Map)collectionClass.newInstance();
    }
}

