/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;

public class Input2InputTransformer
extends BaseTransformer<Object[], Object[]>
implements PullTransformer<Object[], Object[]> {
    protected Mediator mediator;

    public Input2InputTransformer(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public String getSourceDataBinding() {
        return "idl:input";
    }

    public String getTargetDataBinding() {
        return "idl:input";
    }

    protected Class<Object[]> getSourceType() {
        return Object[].class;
    }

    protected Class<Object[]> getTargetType() {
        return Object[].class;
    }

    public int getWeight() {
        return 10000;
    }

    private boolean matches(WrapperInfo w1, WrapperInfo w2) {
        if (w1 == null || w2 == null) {
            return false;
        }
        if (!w1.getWrapperElement().equals((Object)w2.getWrapperElement())) {
            return false;
        }
        List list1 = w1.getChildElements();
        List list2 = w2.getChildElements();
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            String n1 = ((ElementInfo)list1.get(i)).getQName().getLocalPart();
            String n2 = ((ElementInfo)list2.get(i)).getQName().getLocalPart();
            if (Input2InputTransformer.stripLeadingUnderscore(n1).equals(Input2InputTransformer.stripLeadingUnderscore(n2))) continue;
            return false;
        }
        return true;
    }

    private static String stripLeadingUnderscore(String name) {
        return name.startsWith("_") ? name.substring(1) : name;
    }

    public Object[] transform(Object[] source, TransformationContext context) {
        DataType sourceType = context.getSourceDataType();
        Operation sourceOp = context.getSourceOperation();
        boolean sourceWrapped = sourceOp != null && sourceOp.isInputWrapperStyle() && sourceOp.getInputWrapper() != null;
        boolean sourceNotSubjectToWrapping = sourceOp != null && sourceOp.isNotSubjectToWrapping();
        WrapperHandler sourceWrapperHandler = null;
        String sourceDataBinding = this.getDataBinding(sourceOp);
        sourceWrapperHandler = this.getWrapperHandler(sourceDataBinding, sourceWrapped);
        DataType targetType = context.getTargetDataType();
        Operation targetOp = context.getTargetOperation();
        boolean targetWrapped = targetOp != null && targetOp.isInputWrapperStyle() && targetOp.getInputWrapper() != null;
        boolean targetNotSubjectToWrapping = targetOp != null && targetOp.isNotSubjectToWrapping();
        WrapperHandler targetWrapperHandler = null;
        String targetDataBinding = this.getDataBinding(targetOp);
        targetWrapperHandler = this.getWrapperHandler(targetDataBinding, targetWrapped);
        if (!sourceWrapped && !sourceNotSubjectToWrapping && targetWrapped) {
            WrapperInfo wrapper = targetOp.getInputWrapper();
            if (source == null) {
                Object targetWrapper = targetWrapperHandler.create(targetOp, true);
                return new Object[]{targetWrapper};
            }
            if (sourceWrapperHandler != null) {
                DataType sourceWrapperType;
                WrapperInfo sourceWrapperInfo = sourceOp.getInputWrapper();
                DataType dataType = sourceWrapperType = sourceWrapperInfo != null ? sourceWrapperInfo.getWrapperType() : null;
                if (sourceWrapperType != null && this.matches(sourceOp.getInputWrapper(), targetOp.getInputWrapper())) {
                    Class sourceWrapperClass = sourceWrapperType.getPhysical();
                    Object sourceWrapper = sourceWrapperHandler.create(sourceOp, true);
                    if (sourceWrapper != null) {
                        sourceWrapperHandler.setChildren(sourceWrapper, source, sourceOp, true);
                        Object targetWrapper = this.mediator.mediate(sourceWrapper, sourceWrapperType, (DataType)((List)targetType.getLogical()).get(0), context.getMetadata());
                        return new Object[]{targetWrapper};
                    }
                }
            }
            Object targetWrapper = targetWrapperHandler.create(targetOp, true);
            List argTypes = (List)wrapper.getUnwrappedType().getLogical();
            Object[] targetChildren = new Object[source.length];
            for (int i = 0; i < source.length; ++i) {
                DataType argType = (DataType)argTypes.get(i);
                targetChildren[i] = this.mediator.mediate(source[i], (DataType)((List)sourceType.getLogical()).get(i), argType, context.getMetadata());
            }
            targetWrapperHandler.setChildren(targetWrapper, targetChildren, targetOp, true);
            return new Object[]{targetWrapper};
        }
        if (sourceWrapped && !targetWrapped && !targetNotSubjectToWrapping) {
            Object sourceWrapper = source[0];
            Object[] target = null;
            if (targetWrapperHandler != null && sourceWrapperHandler.isInstance(sourceWrapper, sourceOp, true)) {
                DataType targetWrapperType;
                WrapperInfo targetWrapperInfo = targetOp.getInputWrapper();
                DataType dataType = targetWrapperType = targetWrapperInfo != null ? targetWrapperInfo.getWrapperType() : null;
                if (targetWrapperType != null && this.matches(sourceOp.getInputWrapper(), targetOp.getInputWrapper())) {
                    Object targetWrapper = this.mediator.mediate(sourceWrapper, (DataType)((List)sourceType.getLogical()).get(0), targetWrapperType, context.getMetadata());
                    target = targetWrapperHandler.getChildren(targetWrapper, targetOp, true).toArray();
                    return target;
                }
            }
            Object[] sourceChildren = sourceWrapperHandler.getChildren(sourceWrapper, sourceOp, true).toArray();
            target = new Object[sourceChildren.length];
            for (int i = 0; i < sourceChildren.length; ++i) {
                DataType childType = (DataType)((List)sourceOp.getInputWrapper().getUnwrappedType().getLogical()).get(i);
                target[i] = this.mediator.mediate(sourceChildren[i], childType, (DataType)((List)targetType.getLogical()).get(i), context.getMetadata());
            }
            return target;
        }
        Object[] newArgs = new Object[source.length];
        for (int i = 0; i < source.length; ++i) {
            Object child;
            newArgs[i] = child = this.mediator.mediate(source[i], (DataType)((List)sourceType.getLogical()).get(i), (DataType)((List)targetType.getLogical()).get(i), context.getMetadata());
        }
        return newArgs;
    }

    private WrapperHandler getWrapperHandler(String dataBindingId, boolean required) {
        WrapperHandler wrapperHandler = null;
        if (dataBindingId != null) {
            DataBinding dataBinding = this.mediator.getDataBindings().getDataBinding(dataBindingId);
            WrapperHandler wrapperHandler2 = wrapperHandler = dataBinding == null ? null : dataBinding.getWrapperHandler();
        }
        if (wrapperHandler == null && required) {
            throw new TransformationException("No wrapper handler is provided for databinding: " + dataBindingId);
        }
        return wrapperHandler;
    }

    private String getDataBinding(Operation operation) {
        WrapperInfo wrapper = operation.getInputWrapper();
        if (wrapper != null) {
            return wrapper.getDataBinding();
        }
        return null;
    }
}

